<?php
/**
 * アップグレードFlavor画面(0)クラス
 *
 * アップグレードFlavor画面(0)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class upgrade extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * バージョン情報格納用変数
     * @access private
     * @var    array
     */
    private $versioninfo;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // ディレクトリ名からバージョン情報を取得する
      $this->versioninfo = explode( '_to_', str_replace( 'upgrade' . DIRECTORY_SEPARATOR, '', $this->obj_sess->sessLoad( 'currentcage' ) ) );
      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(upgrade)';

      // アサイン
      $this->smarty->assign ( 'header',  $html_header );

      $this->smarty->assign ( 'cage',    str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );
      $this->smarty->assign ( 'fromVer', $this->versioninfo[0] );
      $this->smarty->assign ( 'toVer',   $this->versioninfo[1] );

      $this->smarty->assign ( 'target',  $this->target );

      // 表示
      $this->smarty->display( 'upgrade.tpl' );

      return true;

    } // end of function:view()

  } // end of class:install
?>
