<?php
/**
 * 新規グループ追加完了画面クラス
 *
 * 新規グループ追加完了画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_user_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class groupadd_complete extends admin_user_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.user」でない or 前画面のActが「groupadd_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.user' or ( $tmp_act != 'groupadd_confirm' ) )
      {
        $this->obj_util->redirectTo( 'groupadd_entry', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッションから値を取得し、セッションを削除
      //------------------------------------------------------------------------
      $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisolutoDb();



      //------------------------------------------------------------------------
      // 現在の最新IDを取得
      //------------------------------------------------------------------------
      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT MAX( `groups`.`group_id` ) + 1 as latest_id
                FROM `risoluto_m_group` groups
                 FOR UPDATE;

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Latest group_id Get Failure' );
          return false;
        } // end of if
        // 入力された値と、取得した値を使ってデータをインサートする
        else
        {

          // 取得したIDが下限値を下回っていた場合（＝ユーザ領域データが1つもない）、
          // 下限値をIDとして使用する
          if ( $tmp_result[ 'latest_id' ] < $this->obj_conf->get( 'LIMITS', 'id_lower' ) )
          {
            $tmp_result[ 'latest_id' ] = $this->obj_conf->get( 'LIMITS', 'id_lower' );
          }// end of if
          // 取得したIDが上限値を上回っていた場合、例外を投げる
          if ( $tmp_result[ 'latest_id' ] > $this->obj_conf->get( 'LIMITS', 'id_upper' ) )
          {
            // 接続をクローズする
            $this->obj_db->dbDisConnect();
            throw new Exception( 'id was exceeded upper limit' );
             return false;
          }// end of if

          // トランザクションを開始
          $this->obj_db->dbBeginTransaction();

          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              INSERT INTO `risoluto_m_group`
              (
                  `ctime`
                , `cuser`
                , `mtime`
                , `muser`
                , `group_id`
                , `group_name`
                , `status`
              ) VALUES (
                  now()
                , ?
                , now()
                , ?
                , ?
                , ?
                , 1
              );

End_Of_SQL;

          // パラメタも用意する
          $tmp_myself = $this->obj_util->answerMyId();
          $param = array(
                          $tmp_myself
                        , $tmp_myself
                        , $tmp_result [ 'latest_id' ]
                        , $tmp_entered[ 'groupname' ]
                        );

          // Insertを実行
          $tmp_insert_result = $this->obj_db->dbExecSQL( $sql, $param );
          if ( PEAR::isError( $tmp_insert_result ) )
          {
            // エラーの場合はロールバックして接続を閉じ、例外を投げる
            $this->obj_db->dbRollback();
            $this->obj_db->dbDisConnect();
            throw new Exception( 'Insert Failure' );
            return false;
          } // end of if
          else
          {
            // 正常に実行できた場合はコミットして接続を閉じる
            $this->obj_db->dbCommit();
            $this->obj_db->dbDisConnect();
          } // end of else

        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage', $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',  $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      // 表示
      $this->smarty->display( 'groupadd_complete.tpl' );

      return true;

    } // end of function:view()

  } // end of class:groupadd_complete

?>
