<?php
/**
 * ブログ記事情報画面クラス
 *
 * ブログ記事情報画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  /**
   * ページャクラス
   */
  require_once( 'Pager.php' );

  class blogview extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $tmp_t_blog    = $this->mycage . '_t_blog';
        $tmp_t_comment = $this->mycage . '_t_comment';
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_name`                              -- ユーザ名
                   , `blog`.`blog_id`                                -- ブログID
                   , `blog`.`blog_title`                             -- ブログタイトル
                   , `blog`.`blog_body`                              -- ブログ本文
                   , `blog`.`post_datetime`                          -- 投稿日
                   , `comment`.`cnt`                                 -- コメント数
                FROM `risoluto_t_user` user
                   , $tmp_t_blog blog
                      LEFT JOIN
                      (
                         SELECT `comment`.`blog_id`
                              , count( `comment`.`blog_id` ) as cnt
                           FROM $tmp_t_comment comment
                          WHERE `comment`.`status` = 1
                       GROUP BY `comment`.`blog_id`
                      ) comment
                      ON `comment`.`blog_id` = `blog`.`blog_id`
               WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                 AND (
                          TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                       OR (
                            `blog`.`end_datetime` = '0000-00-00 00:00:00'
                          )
                     )
                 AND `blog`.`user_id` = `user`.`user_id`
            ORDER BY `blog`.`post_datetime` DESC
                   , `comment`.`cnt`        DESC
                   , `blog`.`blog_id`       DESC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は値を取得できなかったものとして扱う
          $this->gotDat = null;
        } // end of if
        else
        {
          $this->gotDat = null;
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else


      // 取得した情報を表示に適した形に加工する
      $tmp_result_cooked = array();
      $tmp_baseurl       = $this->obj_util->getBaseUrl();
      $tmp_mycage        = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      for( $cnt = 0 ; $cnt < count( $tmp_result ) ; $cnt ++ )
      {
        $tmp_permanentlink = $tmp_baseurl . '?cage=' . $tmp_mycage . '&amp;act=blogcomment&amp;blogid=' . $tmp_result[ $cnt ][ 'blog_id' ];

        array_push( $tmp_result_cooked, array(
                                               'user_name'         => $tmp_result[ $cnt ][ 'user_name'     ]
                                             , 'blog_id'           => $tmp_result[ $cnt ][ 'blog_id'       ]
                                             , 'blog_title'        => $tmp_result[ $cnt ][ 'blog_title'    ]
                                             , 'enc_blog_title'    => rawurlencode( $tmp_result[ $cnt ][ 'blog_title' ] )
                                             , 'blog_body'         => stripslashes( $tmp_result[ $cnt ][ 'blog_body' ] )
                                             , 'post_datetime'     => $tmp_result[ $cnt ][ 'post_datetime' ]
                                             , 'cnt'               => $tmp_result[ $cnt ][ 'cnt'           ]
                                             , 'permanentlink'     => $tmp_permanentlink
                                             , 'enc_permanentlink' => rawurlencode( $tmp_permanentlink )
                                             )
                  );
      } // end of for



      //------------------------------------------------------------------------
      // pagerのセットアップ
      //------------------------------------------------------------------------
      // pagerオプション値を連想配列にセット
      $pager_params = array(
                       'itemData'              => $tmp_result_cooked
                     , 'urlVar'                => 'p'
                     , 'mode'                  => $this->obj_adminconf->get( 'PAGER', 'mode'          )
                     , 'perPage'               => $this->obj_adminconf->get( 'PAGER', 'perPage'       )
                     , 'delta'                 => $this->obj_adminconf->get( 'PAGER', 'delta'         )
                     , 'prevImg'               => $this->obj_adminconf->get( 'PAGER', 'prevImg'       )
                     , 'nextImg'               => $this->obj_adminconf->get( 'PAGER', 'nextImg'       )
                     , 'firstPagePre'          => $this->obj_adminconf->get( 'PAGER', 'firstPagePre'  )
                     , 'firstPageText'         => $this->obj_adminconf->get( 'PAGER', 'firstPageText' )
                     , 'firstPagePost'         => $this->obj_adminconf->get( 'PAGER', 'firstPagePost' )
                     , 'lastPagePre'           => $this->obj_adminconf->get( 'PAGER', 'lastPagePre'   )
                     , 'lastPageText'          => $this->obj_adminconf->get( 'PAGER', 'lastPageText'  )
                     , 'lastPagePost'          => $this->obj_adminconf->get( 'PAGER', 'firstPagePost' )
                     , 'separator'             => $this->obj_adminconf->get( 'PAGER', 'separator'     )
                     , 'spacesBeforeSeparator' => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt'  )
                     , 'spacesAfterSeparator'  => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt'  )
                     , 'clearIfVoid'           => ( !is_null( $this->obj_adminconf->get( "PAGER", "clearIfVoid" ) ) ? true : false )
      );

      // ページャのインスタンスを生成し、必要なデータを生成する
      $pager                        = & pager::factory( $pager_params );
      $this->gotDat[ 'pager_link' ] = $pager->getLinks();

      // ブログデータについては、一番外にある配列の添え字をゼロスタートへリセットする
      $this->gotDat[ 'pager_dat'  ] = array();
      foreach( $pager->getPageData() as $key => $val )
      {
        array_push( $this->gotDat[ 'pager_dat'  ], $val );
      }

      // ブログタイトルの取得
      $simpleblog_conf = new RisolutoConf();
      $simpleblog_conf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );
      $this->gotDat[ 'title' ] = $simpleblog_conf->get( 'BLOGINFO', 'title' );

      // 付随情報の取得
      $this->gotDat[ 'mycage'  ] = $this->mycage;
      $this->gotDat[ 'baseURL' ] = $this->obj_util->getBaseUrl();

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $headers            = $this->obj_util->getHeader();
      $headers[ 'title' ] = $this->gotDat[ 'title' ] . "（" . $headers[ 'title' ] . '）';
      $this->smarty->assign ( 'header', $headers );

      $this->smarty->assign ( 'bloglist',     $this->gotDat[ 'pager_dat'  ] );
      $this->smarty->assign ( 'pagerlink',    $this->gotDat[ 'pager_link' ][ 'all' ] );

      $this->smarty->assign ( 'mycage',       $this->gotDat[ 'mycage'  ] );
      $this->smarty->assign ( 'baseURL',      $this->gotDat[ 'baseURL' ] );
      $this->smarty->assign ( 'blogname',     $this->gotDat[ 'title' ] );
      $this->smarty->assign ( 'enc_blogname', rawurlencode( $this->gotDat[ 'title' ] ) );

      // 表示
      $this->smarty->display( 'blogview.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogview
?>
