<?php
/**
 * アップロードファイル削除画面クラス
 *
 * アップロードファイル削除画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class upload_del extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // パラメタチェック
      //------------------------------------------------------------------------
      if ( isset( $_GET[ 'id' ] ) and is_numeric( $_GET[ 'id' ] ) )
      {
        $tmp_entered = trim( strip_tags( $_GET[ 'id' ] ) );
      } // end of if



      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();



      //------------------------------------------------------------------------
      // 現在の最新IDを取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              DELETE FROM `risoluto_t_upload`
                    WHERE `upload_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbExecSQL( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Delete upload file information Failure' );
          return false;
        } // end of if
        // ファイルを削除する
        else
        {
          @unlink( RISOLUTO_UPLOAD . '/' . 'risoluto_uploaded_' . $tmp_entered );
        } // end of if
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // すべての処理が終わったら、一覧画面にとばす
      $this->obj_util->redirectTo( 'uploadlist', 'admin.site' );
      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      return true;

    } // end of function:view()

  } // end of class:upload_del

?>
