<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      $this->filelist = array(
                                array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/common.css'
                                     , 'destination' => RISOLUTO_DOCROOT . '/css/common.css'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/extlib_setup.sh'
                                     , 'destination' => RISOLUTO_EXTLIB . 'extlib_setup.sh'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/zipcode.sh'
                                     , 'destination' => RISOLUTO_BATCH . 'zipcode.sh'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/zipcode_batch.php'
                                     , 'destination' => RISOLUTO_BATCH . 'zipcode_batch.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_LOGS . 'trace'
                                     , 'destination' => null
                                     , 'operation'   => 'mkdir'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/risoluto_core.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_core.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/risoluto_db.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_db.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/risoluto_log.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_log.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/risoluto_util.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_util.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/risoluto_admin.ini'
                                     , 'destination' => RISOLUTO_CONF . 'risoluto_admin.ini'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/groupdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/grouplist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/grouplist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/userlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userlist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/usermod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/headerlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerlist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/headermod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/uploadlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadlist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_1_0_to_risoluto-1_1_1/file/uploadviewer.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadviewer.php'
                                     , 'operation'   => 'copy'
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( ! $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
