<?php
/**
 * コンフィグクラス
 *
 * コンフィグ操作のためのファンクション群
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  class RisolutoConf
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * コンフィグ情報を保持する変数
     * @access private
     * @var    array
     */
    private static $arr_parsedconf;
    /**
     * パース状況を保持する変数
     * @access private
     * @var    boolean
     */
    private static $bool_parsestatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * パース状況回答メソッド
     *
     * パース状況を回答するする
     *
     * @param     void    なし
     * @return    boolean ファンクション実行結果（ true：パース済み / false: 未パース ）
     */
    public function is_Parsed()
    {
      return $this->bool_parsestatus;
    } // end of is_Parsed

    /**
     * iniファイルパースメソッド
     *
     * 引数で与えられたパスよりiniファイルを読み込みパースする
     *
     * @param     string    $path    iniファイルのパス
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function parse( $path )
    {

      // ファイルが存在しているかをテスト
      clearstatcache();
      if ( is_file( $path ) )
      {
        // ファイルが存在していれば、
        // 指定されたiniファイルをロードし、パースする
        $this->arr_parsedconf   = parse_ini_file( $path, true );
        $this->bool_parsestatus = true;

        return true;
      } // end of if
      // ファイルが存在しない場合（または読めない場合）、
      // そのまま抜ける
      else
      {

        $this->bool_parsestatus = false;

        return false;
      } // end of else

    } // end of parse

    /**
     * iniファイル情報取得メソッド
     *
     * パース済みiniファイルより、指定されたキーを持つ値を取得する
     * パースされていないかキーが存在しない場合は、nullが返却される
     *
     * @param     string    $section  検索対象のセクション
     * @param     string    $key      検索対象のキー
     * @return    string キーに対応する値 又は null
     */
    public function get( $section, $key )
    {

      // 一度もパースされていない場合は、nullを返す
      if ( !$this->bool_parsestatus )
      {
        return null;
      } // end of if

      $gotDat = $this->arr_parsedconf[ $section ][ $key ];
      if ( !empty( $gotDat ) )
      {
        return $gotDat;
      } // end of if
      else
      {
        return null;
      } // end of else

    } // end of get

  }  // end of class:RisolutoConf
?>
