<?php
/**
 * ログイン画面クラス
 *
 * ログイン画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'admin_base.inc' );

  class login extends admin_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * エラーメッセージ格納用変数
     * @access private
     * @var    string
     */
    private $errMsg;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // すでにスーパバイザセッション又はアドミンセッションが存在する場合は、
      // 管理系メニュー画面に遷移する
      if ( $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'menu_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
        return true;
      } // end of if

      // セッションからエラーメッセージを取得し、削除する
      $this->errMsg = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentact' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentact' ) );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'errMsg',    $this->errMsg );

      // 表示
      $this->smarty->display( 'login.tpl' );

      return true;

    } // end of function:view()

  } // end of class:admin
?>
