﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Twitter;

namespace Quicker
{
    public partial class FormSetting : Form
    {
        /// <summary>
        /// 設定情報
        /// </summary>
        Settings Settings_;

        public FormSetting(Settings settings)
        {
            InitializeComponent();

            Settings_ = settings;
        }

        private void FormSetting_Load(object sender, EventArgs e)
        {
            string fileName = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\QuickerConfigs.xml";

            // アカウント情報の設定
            textBoxAcount.Text = Settings_.Acount;
            textBoxPassword.Text = Settings_.Password;

            // 環境設定の設定
            textBoxHookKey.Text = Settings_.Key;
            checkBoxShift.Checked = Settings_.Shift;
            checkBoxCtrl.Checked = Settings_.Ctrl;
            checkBoxAlt.Checked = Settings_.Alt;
            checkBoxGrayback.Checked = Settings_.Grayback;
       }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            if (textBoxAcount.Text == "")
            {
                MessageBox.Show("アカウント名が入力されていません", "エラー", MessageBoxButtons.OK);
                return;
            }

            if (textBoxPassword.Text == "")
            {
                MessageBox.Show("パスワードが入力されていません", "エラー", MessageBoxButtons.OK);
                return;
            }

            // クライアントの生成
            TwitterClient tc = new TwitterClient(Settings_.Acount, Settings_.Password);
        
            // アカウント情報の更新
            Settings_.Acount = textBoxAcount.Text;
            Settings_.Password = textBoxPassword.Text;

            Settings_.Key = textBoxHookKey.Text;
            Settings_.Shift = checkBoxShift.Checked;
            Settings_.Ctrl = checkBoxCtrl.Checked;
            Settings_.Alt = checkBoxAlt.Checked;

            Settings_.Grayback = checkBoxGrayback.Checked;

            // 保存
            Settings_.save();
            this.Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }


        private void textBoxHookKey_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }

        private void textBoxHookKey_KeyDown(object sender, KeyEventArgs e)
        {
            KeysConverter kc = new KeysConverter();
            textBoxHookKey.Text = kc.ConvertToString(e.KeyCode);
        }
    }
}
