﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography;

namespace DPLib
{
    public class DataProtection
    {
        //暗号化で使用する追加のバイト配列
        private byte[] Entropy = new byte[] { 0x91, 0x93, 0x80, 0x31 };

        /// <summary>
        /// 暗号化
        /// </summary>
        /// <param name="data">生データ</param>
        /// <returns>暗号化データ</returns>
        public string protect(string data)
        {
            //文字列をバイト型配列に変換
            byte[] userData = Encoding.UTF8.GetBytes(data);

            //暗号化する
            byte[] encryptedData = 
                ProtectedData.Protect(userData, this.Entropy, DataProtectionScope.CurrentUser);

            //暗号化されたデータを文字列に変換して返す
            return Convert.ToBase64String(encryptedData);
        }

        //TextBox2の値を復号化し、TextBox1に表示する
        //Button2のClickイベントハンドラ
        public string unprotect(string data)
        {
            //文字列を暗号化されたデータに戻す
            byte[] encryptedData = Convert.FromBase64String(data);

            string rtn = "";
            //復号化する
            try
            {
                byte[] userData = ProtectedData.Unprotect(encryptedData, this.Entropy, DataProtectionScope.CurrentUser);
                //復号化されたデータを文字列に変換
                rtn = Encoding.UTF8.GetString(userData);
            }
            catch (CryptographicException /*ex*/)
            {
            }

            return rtn;
        }
    }
}
