<?php
/**
 * @copyright 2005-2006 OpenPNE Project
 * @license   http://www.php.net/license/3_01.txt PHP License 3.01
 */

class pc_page_c_exchange_add_confirm extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();

        // --- リクエスト変数
        $target_c_commu_id = $requests['target_c_commu_id'];
        $event_flag = $requests['event_flag'];
        // ----------

        //--- 権限チェック
        //コミュニティメンバー
        if (!db_commu_is_c_commu_member($target_c_commu_id, $u)) {
            $_REQUEST['target_c_commu_id'] = $target_c_commu_id;
            $_REQUEST['msg'] = "イベント作成をおこなうにはコミュニティに参加する必要があります";
            openpne_forward('pc', 'page', "c_home");
            exit;
        }

        $c_commu = db_commu_c_commu4c_commu_id2($target_c_commu_id);

        //トピック作成権限チェック
        if ($c_commu['topic_authority'] == 'admin_only' && !db_commu_is_c_commu_admin($target_c_commu_id, $u)) {
            $_REQUEST['target_c_commu_id'] = $target_c_commu_id;
            $_REQUEST['msg'] = "イベントは管理者だけが作成できます";
            openpne_forward('pc', 'page', "c_home");
            exit;
        }
        //---

        $exchange = p_c_exchange_add_confirm_exchange4request();
        $upfile_obj1 = $_FILES['image_filename1'];
        $upfile_obj2 = $_FILES['image_filename2'];
        $upfile_obj3 = $_FILES['image_filename3'];

        // エラーチェック
        $err_msg = array();
        if (trim($exchange['title']) == '') {
            $err_msg[] = "タイトルを入力してください";
        }
        if (trim($exchange['c_exchange_category_id']) <= 0) {
            $err_msg[] = "カテゴリを入力してください";
        }
        if (trim($exchange['detail']) == '') {
            $err_msg[] = "詳細を入力してください";
        }

        if (!$exchange['open_date_month'] || !$exchange['open_date_day'] || !$exchange['open_date_year']) {
            $err_msg[] = "期間（From）を入力してください";
        } elseif (!t_checkdate($exchange['open_date_month'], $exchange['open_date_day'], $exchange['open_date_year'])) {
            $err_msg[] = "期間（From）は存在しません";
        } elseif (mktime(0, 0, 0, $exchange['open_date_month'], $exchange['open_date_day'], $exchange['open_date_year']) < mktime(0, 0, 0)) {
            $err_msg[] = "期間（From）は過去に指定できません";
        }

        if (!$exchange['close_date_month'] || !$exchange['close_date_day'] || !$exchange['close_date_year']) {
            $err_msg[] = "期間（To）を入力してください";
        } elseif (!t_checkdate($exchange['close_date_month'], $exchange['close_date_day'], $exchange['close_date_year'])) {
            $err_msg[] = "期間（To）は存在しません";
        } elseif (mktime(0, 0, 0, $exchange['close_date_month'], $exchange['close_date_day'], $exchange['close_date_year']) < mktime(0, 0, 0)) {
            $err_msg[] = "期間（To）は過去に指定できません";
        }

        if ($upfile_obj1['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj1))) {
                $err_msg[] = '画像1は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj2['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj2))) {
                $err_msg[] = '画像2は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj3['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj3))) {
                $err_msg[] = '画像3は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }

        if (trim($exchange['amount']) == '') {
            $err_msg[] = "金額（E）を入力してください";
        }
        if (trim($exchange['add_amount']) > trim($exchange['amount'])) {
            $err_msg[] = "金額（円）は最大、金額（E）と同額までです";
        }
        
        if ($err_msg) {
            $_REQUEST = $exchange;
            $_REQUEST['target_c_commu_id'] = $exchange['c_commu_id'];
            $_REQUEST['err_msg'] = $err_msg;
            openpne_forward('pc', 'page', "c_exchange_add");
            exit;
        }

        //画像をvar/tmpフォルダにコピー
        $sessid = session_id();
        t_image_clear_tmp($sessid);
        $tmpfile1 = t_image_save2tmp($upfile_obj1, $sessid, "t_1");
        $tmpfile2 = t_image_save2tmp($upfile_obj2, $sessid, "t_2");
        $tmpfile3 = t_image_save2tmp($upfile_obj3, $sessid, "t_3");

        $this->set('inc_navi', fetch_inc_navi("c", $target_c_commu_id));

        $pref_list = p_regist_prof_c_profile_pref_list4null();
//        $exchange = p_c_exchange_add_confirm_exchange4request();
        $exchange['open_pref_value'] = $pref_list[$exchange['open_pref_id']];
        
        $c_exchange_category_list = db_commu_c_exchange_category4($event_flag);
        $exchange['c_exchange_category_value'] = $c_exchange_category_list[$exchange['c_exchange_category_id']];
        
        $exchange['image_filename1_tmpfile'] = $tmpfile1;
        $exchange['image_filename2_tmpfile'] = $tmpfile2;
        $exchange['image_filename3_tmpfile'] = $tmpfile3;
        $exchange['image_filename1'] = $upfile_obj1['name'];
        $exchange['image_filename2'] = $upfile_obj2['name'];
        $exchange['image_filename3'] = $upfile_obj3['name'];
        $exchange['event_flag'] = $event_flag;
        $this->set('exchange', $exchange);

        return 'success';
    }
}

?>
