<?php
/**
 * @copyright 2005-2006 OpenPNE Project
 * @license   http://www.php.net/license/3_01.txt PHP License 3.01
 */

class pc_do_c_exchange_edit_update_c_commu_topic extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();


        // --- リクエスト変数
        $c_commu_topic_id = $requests['target_c_commu_topic_id'];
        // ----------
        $upfile_obj1 = $_FILES['image_filename1'];
        $upfile_obj2 = $_FILES['image_filename2'];
        $upfile_obj3 = $_FILES['image_filename3'];


        $exchange = p_c_exchange_add_confirm_exchange4request();

        //--- 権限チェック
        //イベント管理者 or コミュニティ管理者

        if (!db_commu_is_c_event_admin($c_commu_topic_id, $u) &&
            !db_commu_is_c_commu_admin($exchange['c_commu_id'], $u)) {
            handle_kengen_error();
        }
        $c_commu = db_commu_c_commu4c_commu_id2($exchange['c_commu_id']);
        if ($c_commu['topic_authority'] == 'admin_only' &&
            !db_commu_is_c_commu_admin($c_commu_id, $u)) {
            handle_kengen_error();
        }
        //---

        // エラーチェック
        $err_msg = array();
        if (trim($exchange['title']) == '') {
            $err_msg[] = "タイトルを入力してください";
        }
        if (trim($exchange['c_exchange_category_id']) <= 0) {
            $err_msg[] = "カテゴリを入力してください";
        }
        if (trim($exchange['detail']) == '') {
            $err_msg[] = "詳細を入力してください";
        }

        if (!$exchange['open_date_month'] || !$exchange['open_date_day'] || !$exchange['open_date_year']) {
            $err_msg[] = "期間（From）を入力してください";
        } elseif (!t_checkdate($exchange['open_date_month'], $exchange['open_date_day'], $exchange['open_date_year'])) {
            $err_msg[] = "期間（From）は存在しません";
        } elseif (mktime(0, 0, 0, $exchange['open_date_month'], $exchange['open_date_day'], $exchange['open_date_year']) < mktime(0, 0, 0)) {
            $err_msg[] = "期間（From）は過去に指定できません";
        }

        if (!$exchange['close_date_month'] || !$exchange['close_date_day'] || !$exchange['close_date_year']) {
            $err_msg[] = "期間（To）を入力してください";
        } elseif (!t_checkdate($exchange['close_date_month'], $exchange['close_date_day'], $exchange['close_date_year'])) {
            $err_msg[] = "期間（To）は存在しません";
        } elseif (mktime(0, 0, 0, $exchange['close_date_month'], $exchange['close_date_day'], $exchange['close_date_year']) < mktime(0, 0, 0)) {
            $err_msg[] = "期間（To）は過去に指定できません";
        }

        if ($upfile_obj1['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj1))) {
                $err_msg[] = '画像1は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj2['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj2))) {
                $err_msg[] = '画像2は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }
        if ($upfile_obj3['error'] !== UPLOAD_ERR_NO_FILE) {
            if (!($image = t_check_image($upfile_obj3))) {
                $err_msg[] = '画像3は'.IMAGE_MAX_FILESIZE.'KB以内のGIF・JPEG・PNGにしてください';
            }
        }

        if (trim($exchange['amount']) == '') {
            $err_msg[] = "金額（E）を入力してください";
        }
        
        if ($err_msg) {
            $_REQUEST = $exchange;
            $_REQUEST['target_c_commu_topic_id'] = $c_commu_topic_id;
            $_REQUEST['err_msg'] = $err_msg;
            openpne_forward('pc', 'page', "c_exchange_edit");
            exit;
        }

        //画像コピー
        $sessid = session_id();
        t_image_clear_tmp($sessid);
        if (file_exists($upfile_obj1["tmp_name"])) {
            $tmpfile1 = t_image_save2tmp($upfile_obj1, $sessid, "t_1");
        }
        if (file_exists($upfile_obj2["tmp_name"])) {
            $tmpfile2 = t_image_save2tmp($upfile_obj2, $sessid, "t_2");
        }
        if (file_exists($upfile_obj3["tmp_name"])) {
            $tmpfile3 = t_image_save2tmp($upfile_obj3, $sessid, "t_3");
        }

        if ($tmpfile1) {
            $filename1 = image_insert_c_image4tmp("t_{$c_commu_topic_id}_1", $tmpfile1);
        }
        if ($tmpfile2) {
            $filename2 = image_insert_c_image4tmp("t_{$c_commu_topic_id}_2", $tmpfile2);
        }
        if ($tmpfile3) {
            $filename3 = image_insert_c_image4tmp("t_{$c_commu_topic_id}_3", $tmpfile3);
        }
        t_image_clear_tmp(session_id());


        $update_c_commu_topic = array(
           "name"              => $exchange['title'],
           "event_flag"              => $exchange['event_flag'],
            "c_exchange_category_id" => $exchange['c_exchange_category_id'],
            "open_date"         => $exchange['open_date_year']."-".$exchange['open_date_month']."-".$exchange['open_date_day'],
            "open_date_comment" => $exchange['open_date_comment'],
            "close_date"        => $exchange['close_date_year']."-".$exchange['close_date_month']."-".$exchange['close_date_day'],
            "close_date_comment"=> $exchange['close_date_comment'],
            "open_pref_id"      => $exchange['open_pref_id'],
            "open_pref_comment" => $exchange['open_pref_comment'],
            "amount"            => $exchange['amount'],
            "add_amount"        => $exchange['add_amount'],
        );
        db_commu_update_c_commu_topic($c_commu_topic_id, $update_c_commu_topic);


        $update_c_commu_topic_comment = array(
            'body' => $exchange['detail'],
        );
        $c_topic = db_commu_c_topic4c_commu_topic_id_2($c_commu_topic_id);
        if ($filename1) {
            $update_c_commu_topic_comment["image_filename1"] = $filename1;
            image_data_delete($c_topic['image_filename1']);
        }
        if ($filename2) {
            $update_c_commu_topic_comment["image_filename2"] = $filename2;
            image_data_delete($c_topic['image_filename2']);
        }
        if ($filename3) {
            $update_c_commu_topic_comment["image_filename3"] = $filename3;
            image_data_delete($c_topic['image_filename3']);
        }
        db_commu_update_c_commu_topic_comment($c_commu_topic_id, $update_c_commu_topic_comment);

        $p = array('target_c_commu_topic_id' => $c_commu_topic_id);
        openpne_redirect('pc', 'page_c_exchange_detail', $p);
    }
}

?>
