require "rexml/document"
require 'debug/rpgxpdt_log.rb'

def fods2csv(filename,project_dir)
  prefix = project_dir + 'csv/DB/'
  Debug.log("fods2csv(#{filename},#{project_dir})") if $DEBUG
  file = nil
  begin
    file = File.new(filename)
    t1 = File.mtime(filename)
    Debug.log("read #{filename}") if $DEBUG
    doc = REXML::Document.new(file)
    doc.elements().each("*/office:body/office:spreadsheet/table:table") do |t|
      out = nil
      begin
        csv_filename = prefix + t.attributes['name'] + '.csv'
        if FileTest.exists?(csv_filename)
          t2 = File.mtime(csv_filename)
          if t1 < t2
            next
          end
        end
        Debug.log("create #{csv_filename}") if $DEBUG
        out = File.new(csv_filename,'w+')
        t.elements.each("table:table-row") do |row|
          cells = []
          row.elements.each('table:table-cell') do |cell|
            node = cell.elements['text:p']
            text = ''
            if (not node.nil?) and (not node.text.nil?)
              text = node.text
            end
            cells.push(text)
            n = cell.attributes['number-columns-repeated'].to_i - 1
            n.times {cells.push(text)}
          end
          while cells.empty?() and cells.last.empty?()
            cells.pop
          end
          if not cells.empty?()
            out.puts cells.join(',')
          end
        end
      ensure
        out.close() if not out.nil?
      end
    end
  ensure
    file.close() if not file.nil?
  end
end
