module Event_Export
  extend Data_Loader

  module_function
  
  #
  def _load_map_data(map_id)
    filename = sprintf("Data/Map%03d.rxdata", map_id)
    if Log.debug?
      Log.debug("_load_map_data #{filename}")
    end
    return load_data(filename)
  end
  
  def conf()
    @conf ||= {
      :output_dir => nil,
      :map => {}
    }
    # map ==> { 1 => { :event_id => [1] } }
  end

  #
  def export(op={})
    conf.update(op)
    
    output_dir = conf[:output_dir]
    
    data_map_infos.each() do |map_id,v|
      if conf[:map].size() > 0
        if not conf[:map].member?(map_id)
          next
        end
      end
      dirname = "%03d" % map_id
      if not FileTest.exist?(output_dir + dirname)
        Dir.mkdir(output_dir + dirname)
      end
      export_map(output_dir + dirname,map_id,v)
    end
  end

  #
  def export_map(output_dir,map_id,map_info)
    map_data = _load_map_data(map_id)
    map_data.events.each() do |event_id,event|
      if conf[:map].size() > 0 and conf[:map][map_id].size() > 0
        if not conf[:map][map_id][:event_id].include?(event_id)
          next
        end
      end
      export_event(output_dir,event)
    end
  end
  
  #
  def export_event(output_dir,event)
    filename = ('(%02d-%02d-%02d)%s.txt' % [event.x, event.y, event.id, event.name]).tosjis()
    puts filename
    page_num = 0
    page_names = event.pages.collect() do |page|
      page_num += 1
      if page.list[0].code == 108
        page.list[0].parameters[0]
      else
        '%03d' % page_num
      end
    end

# XXX
    out = STDOUT
    
    out << 'pages=' << page_names.join(',') << "\n"
    out << "\n"
    event.pages.zip(page_names) do |page,name|
      out << "---\n"
      out << export_page(name,page)
      out << "\n"
    end
  end
  
  def export_page(page_name,page,out='')
    out << 'page.name=' << page_name << "\n"
    %W(
      move_type
      move_speed
      move_frequency
      walk_anime
      step_anime
      direction_fix
      through
      always_on_top
      trigger
    ).each() do |attr|
      out << attr << '=' << page.send(attr).to_s << "\n"
    end
    if page.move_type == 3 # 3:JX^
      out << Move_Route_Util.export(page.move_route)
    end
    data = {}
    page.list.each() do |event_command|
      out << Event_Command_Util.export(data,event_command)
      out << "\n"
    end
    
    return out
  end

end
