require 'debug/rpgxpdt_log'
require 'debug/rgss_base'
require 'tools/dbc/data_compiler'
require 'tools/dbc/rxdata_value_creator'

module DBC
  class RXData_Compiler < Data_Compiler
    @@rxdata_compiler = {}

    def self.get_compiler(filename)
      if not @@rxdata_compiler.member?(filename)
      @@rxdata_compiler[filename] = RXData_Compiler.new(filename)
      end
      return @@rxdata_compiler[filename]
    end

    $TRACE = false if not defined? $TRACE
    if $DEBUG
      attr_accessor :data_dir
    end

    # 
    def initialize(filename)
      super(filename)
      @value_creator = DBC::RXData_Value_Creator.new(self)
      @data_dir = './Data/'
    end

    COMPILE_TYPES = {
      'System'  => 'RPG::System',
      'States'  => 'RPG::State',
      'Skills'  => 'RPG::Skill',
      'Items'   => 'RPG::Item',
      'Weapons' => 'RPG::Weapon',
      'Armors'  => 'RPG::Armor',
      'Enemies' => 'RPG::Enemy',
      'Classes' => 'RPG::Class',
      'Actors'  => 'RPG::Actor'
    }

    def load_object(name)
      Debug.log('load_object: start ' + name) if $TRACE
      section_data = load_section(name)
      objs = create_objects(section_data)
      Debug.log('load_object: end') if $TRACE
      return objs
    end

    # f[^zɂB
    # IDz̃CfbNXƂėpB
    # data:: id L[ Hash
    def to_data_array(data)
      list = [nil]
      data.keys().sort().each() do |id|
        list[id] = data[id]
      end
      return list
    end
    private :to_data_array

    # RpC
    def compile(name)
      Debug.log('comile: start ' + name) if $TRACE
      data = nil
      objects = load_object(name)
      if not objects.nil?
        if objects.is_a?(Hash)
          if not objects.empty?
            klass = COMPILE_TYPES[name]
            list = to_data_array(objects[klass]['id'])
            save_data(list,@data_dir + name + '.rxdata')
            data = load_data(@data_dir + name + '.rxdata')
          end
        else
          save_data(objects,@data_dir + name + '.rxdata')
          data = load_data(@data_dir + name + '.rxdata')
        end
      end
      Debug.log('comile: end') if $TRACE
      return data
    end

    # VXef[^̃RpC
    def compile_system()
      Debug.log('comile_system: start') if $TRACE
      data = compile('System')
      Debug.log('comile_system: end') if $TRACE
      return data
    end

    # Xe[^X̃RpC
    # [class] RPG::State [key] id
    def compile_states()
      Debug.log('comile_states: start') if $TRACE
      data = compile('States')
      Debug.log('comile_states: end') if $TRACE
      return data
    end

    # XL̃RpC
    def compile_skills()
      Debug.log('compile_skills: start') if $TRACE
      data = compile('Skills')
      Debug.log('compile_skills: end') if $TRACE
      return data
    end

    # ACẽRpC
    def compile_items()
      Debug.log('compile_items: start') if $TRACE
      data = compile('Items')
      Debug.log('compile_items: end') if $TRACE
      return data
    end

    # ̃RpC
    def compile_weapons()
      Debug.log('compile_weapons: start') if $TRACE
      data = compile('Weapons')
      Debug.log('compile_weapons: end') if $TRACE
      return data
    end

    # h̃RpC
    def compile_armors()
      Debug.log('compile_armors: start') if $TRACE
      data = compile('Armors')
      Debug.log('compile_armors: end') if $TRACE
      return data
    end

    # G̃RpC
    def compile_enemies()
      Debug.log('compile_enemies: start') if $TRACE
      data = compile('Enemies')
      Debug.log('compile_enemies: end') if $TRACE
      return data
    end

    # NX̃RpC
    def compile_classes()
      Debug.log('compile_classes: start') if $TRACE
      data = compile('Classes')
      Debug.log('compile_classes: end') if $TRACE
      return data
    end

    # AN^[̃RpC
    def compile_actors()
      Debug.log('compile_actors: start') if $TRACE
      data = compile('Actors')
      Debug.log('compile_actors: end') if $TRACE
      return data
    end
  end
end

def rxdc(filename,sheetname)
  compiler = DBC::RXData_Compiler.get_compiler(filename)
  compiler.compile(sheetname)
end

def csvc(filename,sheetname,target,col_names)
  compiler = DBC::RXData_Compiler.get_compiler(filename)
  compiler.compile_csv(target,sheetname,col_names)
end

def propc(filename,sheetname,target,col_names)
  compiler = DBC::RXData_Compiler.get_compiler(filename)
  compiler.compile_properties(target,sheetname,col_names)
end
