# ACegf[^p[T
# Author:: fukuyama
# Date:: 2008/12/14
# Copyright:: Copyright (c) 2008 rgss-lib

# t@CtH[}bg
# name,base_item_id,base_item_type,name_pos,level,attributes,help_text
# name::
# base_item_id::
# base_item_type::
# name_pos::
# level::
# attributes::
# help_text::

module Parser
  # ACegf[^p[T
  class Item_Expansion_Parser < Parser_Base
    # BData_Loadler Kv
    def initialize
      super
      @klass = RPG::Item_Expansion
      @names = ['datakey','name','base_item_id','base_item_type','name_pos','level','attributes','help_text','alias_names']
      add_parse('base_item_id',:parse_number) # XXX: ΉȂƂ߂
      add_parse('base_item_type',:parse_base_item_type) # XXX: ΉȂƂ߂
      add_parse('name_pos',:parse_name_pos)
      add_parse('level',:parse_number)
      add_parse('attributes',:parse_attributes)
      add_parse('alias_names',:parse_alias_names)
      @base_item_types = {
        'item'   => RPG::Item_Expansion::TYPE_ITEM,
        'weapon' => RPG::Item_Expansion::TYPE_WEAPON,
        'armor'  => RPG::Item_Expansion::TYPE_ARMOR,
      }
      @name_pos = {
        'prefix' => RPG::Item_Expansion::POS_PREFIX,
        'suffix' => RPG::Item_Expansion::POS_SUFFIX,
      }
      @attributes = Data_Loader.data_item_attr # Hash
    end

    # gf[^p[X
    def parse_attributes(v)
      v.split(/\s+/)
    end

    # x[XACe̎ނp[X
    def parse_base_item_type(v)
      @base_item_types[v]
    end

    # Otʒup[X
    def parse_name_pos(v)
      @name_pos[v]
    end
    
    # gGCAX̃p[X
    def parse_alias_names(v)
      result = {}
      return result if v.nil?
      v.split(/\s+/).each() do |data|
        (key,val) = data.split(/:/)
        result[key.to_i] = val
      end
      return result
    end

  end

end
