# ACegf[^
# Q[IuWFNg
# Author:: fukuyama
# Date:: 2008/12/12
# Copyright:: Copyright (c) 2008 rgss-lib

# ACegf[^NX
class Game_Item_Expansion

  # g
  attr_accessor :name
  # gGCAX
  attr_accessor :alias_names
  # x[XACehc
  attr_accessor :base_item_id
  # x[XACe̎
  attr_accessor :base_item_type
  # g̕tʒuBRPG::Item_Expansion::POS_PREFIX | RPG::Item_Expansion::POS_SUFFIX
  attr_accessor :name_pos
  # gf[^̃xBʂقǃxȂB
  attr_accessor :level
  # ڍו\̃wveLXg
  attr_accessor :help_text
  # gf[^̃Xg
  attr_accessor :attributes
  # 
  # ex:: ɂȂgf[^(RPG::Item_Expansion)
  # generator:: ACeWFl[^[ Game_Item_Generator
  def initialize(ex,generator)
    @name           = ex.name
    @alias_names    = ex.alias_names
    @base_item_id   = ex.base_item_id
    @base_item_type = ex.base_item_type
    @name_pos       = ex.name_pos
    @level          = ex.level
    @help_text      = ex.help_text
    @attributes     = generator.create_item_attributes(ex.attributes)
  end

  # gf[^f
  # item:: gf[^𔽉fACe Game_Item | Game_Weapon | Game_Armor
  def apply(item)
    # TODO Ŋgf[^̕t\`FbNKvH

    # ڍׂȖO̐ݒ
    nm = @name
    if @alias_names.key?(item.id)
      nm = @alias_names[item.id]
    end
    case @name_pos
    when RPG::Item_Expansion::POS_PREFIX
      item.name_detail = nm + item.name_detail
    when RPG::Item_Expansion::POS_SUFFIX
      item.name_detail = item.name_detail + nm
    end
    # ̔f
    @attributes.each do |a|
      a.apply(item)
    end

    unless @help_text.nil? or @help_text == ""
      if item.description.nil? or item.description == ""
        item.description = @help_text
      else
        item.description = item.description + "\n" + @help_text
      end
    end
  end

end
