

module Window_Sprite_Cursor_Module
  # J[\XvCg̍쐬
  def create_sprite_cursor
    return Sprite_Cursor.new(self.viewport)
  end
  
  # J[\XvCg̎擾
  def sprite_cursor
    if @sprite_cursor.nil?
      self.cursor_rect.empty
      @sprite_cursor = create_sprite_cursor
      @sprite_cursor.z = self.z + 1
    end
    return @sprite_cursor
  end
  
  # J[\XvCg̈ړ
  def move_cursor_sprite
    tx = 4 + 16 / 2 - sprite_cursor.src_rect.width / 2
    ty = 16 + rect.height / 2 - sprite_cursor.src_rect.height / 2
    sprite_cursor.x = self.x + rect.x + tx
    sprite_cursor.y = self.y + rect.y + ty
    sprite_cursor.z = self.z + 1
  end
  
  # J[\XvCg̍XV
  def update_cursor_sprite
    return if self.disposed?
    return if self.contents.nil?
    if @sprite_cursor.nil?
      sprite_cursor.visible = false
      return
    end
    sprite_cursor.visible = self.visible
    if self.active
      @sprite_cursor.white_blink_on
    else
      @sprite_cursor.white_blink_off
    end
    sprite_cursor.update
  end
  
  # EBhEƃJ[\̉Ԃ𓯊
  def visible=(arg)
    super(arg)
    if not @sprite_cursor.nil?
      sprite_cursor.visible = self.visible
    end
  end
  
  # EBhE폜ɃJ[\
  def dispose
    if not @sprite_cursor.nil?
      @sprite_cursor.dispose
    end
    super
  end
end

module DQ
  class Sprite_InputNumber_Cursor < ::Sprite_Cursor
    def initialize_cursor_bitmap
      self.bitmap = Script_Bitmap.get('number_cursor')
    end
  end
end

class Window_Message_InputNumber
  include Window_Sprite_Cursor_Module
  def create_sprite_cursor
    return DQ::Sprite_InputNumber_Cursor.new(self.viewport)
  end
  def update_cursor_rect
    update_cursor_sprite
    rect = Rect.new(@index * @cursor_width, 0, @cursor_width, 32)
    tx = 16 + rect.width / 2 - sprite_cursor.src_rect.width / 2
    ty = 16 + rect.height / 2 - sprite_cursor.src_rect.height / 2
    sprite_cursor.x = self.x + rect.x + tx
    sprite_cursor.y = self.y + rect.y + ty
  end
end
