#==============================================================================
#  Window_Status_Equip
#------------------------------------------------------------------------------
# AN^[ACe
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

#----------------------------------------------------------------------------
#  ACeEBhE 'Actor_Equip_Item'
#----------------------------------------------------------------------------
class Window_Status_Equip < Window_Base
  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(actor)
    @item_height = ITEM_HEIGHT
    super(0,0, 32 * 6 + 32, @item_height * 5 + 32)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    @actor = actor
    refresh
  end
  #--------------------------------------------------------------------------
  #  AN^[̐ݒ
  #--------------------------------------------------------------------------
  def actor=(actor)
    if @actor != actor
      @actor = actor
      refresh
    end
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear
    return if @actor.nil?

    index = 0
    rect = Rect.new(0,0,self.contents.width,@item_height)
    equip_items = Item_Facade.equip_items(@actor)
    equip_items.each do |item|
      rect.y = index * @item_height
      draw_menu_item(index,normal_color,rect,item)
      index += 1
    end
  end
  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,item)
    name = ''
    name = 'E ' + item.name if not item.nil?
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, name)
  end
end

end
