# IAN^[쐬pCxgXNvg
# Author:: fukuyama
# Date:: 2008/07/05
# Copyright:: Copyright (C) 2008 rgss-lib

module DQ
  Template_Actor = Struct.new(:name,:template)
  module Tkool_Actor_Creator_Event_Script
    # CxgJn
    def event_start
      @actor_status_windows = []

      # ̓EBhE
      @window_input = Window_InputString.new(TITLE_INPUT_NAME_LABEL,INPUT_NAME_MAX_SIZE)
      @window_input.back_opacity = WINDOW_BACK_OPACITY
      @window_input.window_input_area.back_opacity = WINDOW_BACK_OPACITY
      @window_input.auto_dispose = false

      # NXIEBhE
      @window_select_class = Window_Command.new(0,@param_values['class'])
      @window_select_class.back_opacity = WINDOW_BACK_OPACITY
      @window_select_class.active = false
      @window_select_class.visible = false

      # ʑIEBhE
      @window_select_sex = Window_Command.new(0,@param_values['sex'])
      @window_select_sex.back_opacity = WINDOW_BACK_OPACITY
      @window_select_sex.active = false
      @window_select_sex.visible = false

      # ʒu
      @window_select_class.x = 640 / 4 * 1 - @window_select_class.width / 2
      @window_select_sex.x = 640 / 4 * 3 - @window_select_sex.width / 2
      @window_select_class.y = @window_input.top + 32
      @window_select_sex.y = @window_input.top + 32
      @window_select_class.z = @window_input.z + 2
      @window_select_sex.z = @window_input.z + 4

      @window_create_confirm = nil
    end

    # CxgI
    def event_end
      if not @window_input.nil? and not @window_input.disposed?
        @window_input.dispose
      end
      if not @window_select_class.nil? and not @window_select_class.disposed?
        @window_select_class.dispose
      end
      if not @window_select_sex.nil? and not @window_select_sex.disposed?
        @window_select_sex.dispose
      end
      @window_input = nil
      @window_select_class = nil
      @window_select_sex = nil
    end

    # O͏
    def event_update_name
      @window_input.update
      if @window_input.cancel?
        # ͂ȂI
        return false
      end
      if @window_input.input?
        # ͂聄NXI
        @window_input.active = false
        @window_select_class.active = true
        @window_select_class.visible = true
      end
      return true
    end

    # NXI
    def event_update_class
      @window_select_class.update
      if Input.trigger?(Input::C)
        # 
        $game_system.se_play($data_system.decision_se)
        @window_select_class.active = false
        @window_select_sex.active = true
        @window_select_sex.visible = true
      end
      if Input.trigger?(Input::B)
        # LZ
        $game_system.se_play($data_system.cancel_se)
        @window_input.end_status_clear
        @window_input.active = true
        @window_input.visible = true
        @window_select_class.active = false
        @window_select_class.visible = false
      end
      return true
    end

    # ʑI
    def event_update_sex
      @window_select_sex.update
      if Input.trigger?(Input::C)
        # 
        $game_system.se_play($data_system.decision_se)

        # f[^ǉij
        params = {}
        params['name'] = @window_input.text
        params['class'] = @param_values['class'][@window_select_class.index]
        params['sex'] = @param_values['sex'][@window_select_sex.index]
        @data_actor = create(params)
        $data_actors.push @data_actor
        game_actor = Game_Actor.new(@data_actor.id)

        # mFEBhE
        @window_create_confirm = Window_Command.new(0,['͂',''])
        @window_create_label = Window_Command.new(0,'̂ЂƂłłH')

        # AN^[Xe[^X
        window_actor_status = Windowset_Actor_Status.new(@window_create_confirm,game_actor,"center",@window_input.top)
        @actor_status_windows.push window_actor_status

        # ʒu
        @window_create_confirm.right = window_actor_status.window_detail.right
        @window_create_confirm.bottom  = window_actor_status.window_detail.top
        @window_create_label.right = @window_create_confirm.left
        @window_create_label.bottom = @window_create_confirm.bottom

        # ʑJ
        @window_select_sex.active = false
        @window_select_sex.visible = false
        @window_input.visible = false
        @window_select_class.visible = false
      end
      if Input.trigger?(Input::B)
        # LZ
        $game_system.se_play($data_system.cancel_se)
        @window_select_class.active = true
        @window_select_sex.active = false
        @window_select_sex.visible = false
      end
      return true
    end

    # Xe[^XmF
    def event_update_status
      @actor_status_windows.each do |w|
        w.update
      end
      @window_create_confirm.update
      result = true
      status_close = false
      cancel = false
      if Input.trigger?(Input::C)
        # 
        $game_system.se_play($data_system.decision_se)
        if @window_create_confirm.index == 0
          # f[^ǉ
          $game_system.data_actors.push @data_actor
          status_close = true
          result = false
        else
          cancel = true
        end
      end
      if Input.trigger?(Input::B)
        # LZ
        $game_system.se_play($data_system.cancel_se)
        cancel = true
      end
      if status_close or cancel
        @actor_status_windows.each do |w|
          w.dispose
        end
        @actor_status_windows.clear
        @window_create_confirm.dispose
        @window_create_confirm = nil
        @window_create_label.dispose
        @window_create_label = nil
        @data_actor = nil
      end
      if cancel
        @window_select_sex.active = true
        @window_select_sex.visible = true
        @window_input.visible = true
        @window_select_class.visible = true
        $data_actors.pop
      end
      return result
    end

    # CxgXV
    def event_update
      if @window_input.active
        # O͏
        return event_update_name
      end
      if @window_select_class.active
        # NXI
        return event_update_class
      end
      if @window_select_sex.active
        # ʑI
        return event_update_sex
      end
      if not @window_create_confirm.nil?
        # Xe[^XmF
        return event_update_status
      end
    end

    # CxgXNvǧĂяo\bh
    def update
      if @event_object.nil?
        # JnĖꍇJns
        event_start()
        # tOݒ true
        @event_object = true
        return false
      elsif not @event_object
        # tO false ȂIs
        event_end()
        # tO폜
        @event_object = nil
        return true
      else
        # CxgXVXV
        @event_object = event_update()
        return false
      end
    end
  end

  class Tkool_Actor_Creator < Default_Actor_Creator
    include Tkool_Actor_Creator_Event_Script

    attr_reader :param_values
    def initialize
      super
      @rundam_properties = {}
      @data_make_actor = {}
      list = Data_Loader.data_section_map('MakeActorData')
      config = list.find {|o|o['section']=='MakeActorConfig'}
      list.each do |param|
        next if param['character_name'].nil?
        next if param['character_hue'].nil?
        next if param['battler_name'].nil?
        next if param['battler_hue'].nil?
        param['character_name'] = param['character_name'].split(/\s*,\s*/)
        param['character_hue'] = param['character_hue'].to_s.split(/\s*,\s*/).collect {|o|o.to_i}
        param['battler_name'] = param['battler_name'].split(/\s*,\s*/)
        param['battler_hue'] = param['battler_hue'].to_s.split(/\s*,\s*/).collect {|o|o.to_i}
        if $DEBUG
          param['character_name'].each_index do |i|
            RPG::Cache.character(param['character_name'][i],param['character_hue'][i])
          end
        end
        @data_make_actor[param['section']] = param
      end

      @param_values = {}
      @param_values['name']=''

      # ݒ̃[h
      load_config(config);

      # ev[g̃[h
      load_template()
    end

    # ݒǂݍ
    def load_config(config)
      if config.nil?
        p this.class + "#load_config error"
        return
      end
      # `҂̏hɍŏ\AN^[̂hc
      if config.include? 'default_actors'
        v = config['default_actors']
        case v
        when String
          @default_actors = v.split(/\s*,\s*/).collect {|o|o.to_i}
        when Integer
          @default_actors = [v]
        end
      end
      # AN^[쐬ɕ\鐫ʂ̑I
      if config.include? 'sex_values'
        @param_values['sex'] = config['sex_values'].split(/\s*,\s*/)
      else
        @param_values['sex'] = ['Ƃ','']
      end
      # _őIݒ肳AN^[̃vpeB
      if config.include? 'rundam_properties'
        config['rundam_properties'].split(/\s*,\s*/).each do |prop|
          @rundam_properties[prop] = config[prop].split(/\s*,\s*/)
        end
      end
    end

    # ev[g̃[h
    # f[^x[X̃AN^[񂩂ev[g쐬BiOAwwev[g̃AN^[QpӁj
    def load_template
      @param_values['class'] = [] # NXĨXg
      @template_actors = {}
      data_actors = Data_Loader.data_actors
      data_actors.each do |data_actor|
        next if data_actor.nil?
        if data_actor.name =~ /(.+?)ev[g/
          name = $1
          unless @template_actors.include? name
            @param_values['class'].push name
            @template_actors[name] = Template_Actor.new(name,[])
          end
          @template_actors[name].template.push data_actor.id
        end
      end
    end

    # AN^[쐬
    def create(params)
      name = params['name']
      class_name = params['class']
      sex = params['sex']
      return create_data_actor(name,class_name,sex)
    end

    # ev[g瑮lvZ
    def template_calculate_attr(t,s)
      values = t.collect {|i|i.method(s).call}
      min = values.min
      max = values.max
      return min + rand(max - min)
    end

    def create_graphics_param_index(key)
      l = @data_make_actor[key]['character_name']
      return rand(l.size)
    end

    def create_graphics_param(name,key,index)
      l = @data_make_actor[key][name]
      return l[index]
    end

    def create_character_name(key,index)
      return create_graphics_param('character_name',key,index)
    end

    def create_character_hue(key,index)
      return create_graphics_param('character_hue',key,index)
    end

    def create_battler_name(key,index)
      return create_graphics_param('battler_name',key,index)
    end

    def create_battler_hue(key,index)
      return create_graphics_param('battler_hue',key,index)
    end

    # AN^[f[^쐬
    def create_data_actor(name,class_name,sex=nil)
      template = @template_actors[class_name].template.collect {|i| $data_actors[i]}
      data_actor = RPG::Actor.new

      data_actor.id = $data_actors.size                    # IDB
      data_actor.name = name                               # OB
      data_actor.class_id = template[0].class_id           # NX IDB

      # xB
      data_actor.initial_level = template.inject(0) {|r, i| r + i.initial_level} / template.size

      # ŏIxB
      data_actor.final_level = template.inject(0) {|r, i| r + i.final_level} / template.size

      # EXP J[ů{l (10..50)B
      data_actor.exp_basis = template_calculate_attr(template,:exp_basis)

      # EXP J[ȗx (10..50)B
      data_actor.exp_inflation = template_calculate_attr(template,:exp_inflation)

      graphics_key = class_name + sex
      #LN^[OtBbNX̃CfbNX쐬
      graphics_param_index = create_graphics_param_index(graphics_key)
      #LN^[ OtBbÑt@CB
      data_actor.character_name = create_character_name(graphics_key,graphics_param_index)
      #LN^[ OtBbN̐Fωl (0..360) B
      data_actor.character_hue = create_character_hue(graphics_key,graphics_param_index)
      #og[ OtBbÑt@CB
      data_actor.battler_name = create_battler_name(graphics_key,graphics_param_index)
      #og[ OtBbN̐Fωl (0..360) B
      data_actor.battler_hue = create_battler_hue(graphics_key,graphics_param_index)

      rs = []
      for k in 0..5
        rs[k] = (rand() + rand()) / 2.0
      end
      for i in 1..99
        for k in 0..5
          a = template[0].parameters[k,i]
          b = template[1].parameters[k,i]
          n = [a,b].min
          data_actor.parameters[k,i] = (n + (a - b).abs * rs[k]).to_i
        end
      end
      #ex̊{p[^i[񎟌z (Table) B
      # ̓Iɂ́Aparameters[kind, level] Ƃ`ɂȂĂ܂B
      # kind ̓p[^̎ (0:MaxHPA1:MaxSPA2:ŕA3:pA4:fA5:) łB

      data_actor.weapon_id = template[0].weapon_id #ƂĎw肳ꂽ IDB
      data_actor.armor1_id = template[0].armor1_id #ƂĎw肳ꂽ IDB
      data_actor.armor2_id = template[0].armor2_id #ƂĎw肳ꂽh IDB
      data_actor.armor3_id = template[0].armor3_id #ƂĎw肳ꂽg̖h IDB
      data_actor.armor4_id = template[0].armor4_id #ƂĎw肳ꂽi IDB
      data_actor.weapon_fix = template[0].weapon_fix #̑ŒtOB
      data_actor.armor1_fix = template[0].armor1_fix #̑ŒtOB
      data_actor.armor2_fix = template[0].armor2_fix #h̑ŒtOB
      data_actor.armor3_fix = template[0].armor3_fix #g̖h̑ŒtOB
      data_actor.armor4_fix = template[0].armor4_fix #ȋŒtOB

      data_actor.properties['sex'] = sex unless sex.nil?
      @rundam_properties.each_key do |prop|
        l = @rundam_properties[prop]
        data_actor.properties[prop] = l[rand(l.size)]
      end
      return data_actor
    end

  end
  $actor_creator = DQ::Tkool_Actor_Creator.new
end
