# ACep`ohiItem_Facadej
# Author:: fukuyama
# Date:: 2010/07/31
# Copyright (C) 2005-2010 rgss-lib

module Item_Facade
  @@last_result = nil

  module_function
  #--------------------------------------------------------------------------
  # ŌɎs`oh̕ԋpl
  #--------------------------------------------------------------------------
  def last_result
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ǂ̐
  #--------------------------------------------------------------------------
  def arrange_item(actors)
    backpack = $game_party
    for from_actor in actors
      hand_items = []
      from_actor.backpack.each_item do |item|
        hand_items.push item if item.is_a? Game_Item
      end
      for from_item in hand_items
        Item_Facade.trade_item(from_actor,from_item,backpack)
      end
    end
  end

  #--------------------------------------------------------------------------
  # ACe̐
  #--------------------------------------------------------------------------
  def arrange_backpack_type()
    types = [Game_Item,Game_Weapon,Game_Armor]
    sort_backpack($game_party.backpack) {|a,b|
      res = types.index(a.class) <=> types.index(b.class)
      if res == 0
        res = a.id <=> b.id
      end
      res
    }
  end

  def arrange_backpack_name()
    sort_backpack($game_party.backpack) {|a,b|
      a.name <=> b.name
    }
  end

  def sort_backpack(container)
    if container.container?
      container.sort!(&proc)
    end
  end

  #--------------------------------------------------------------------------
  # s\ACe̎擾
  #--------------------------------------------------------------------------
  def get_use_item(item)
    # gp\W[CN[hĂꍇ
    if item.is_a?(Game_Item_Use_Module)
      return item.use_item
    end
    return item
  end

  #--------------------------------------------------------------------------
  # \
  #--------------------------------------------------------------------------
  def equippable?(item,actor)
    if item.class.method_defined?('data_base')
      @@last_result = actor.equippable?(item.data_base)
    else
      @@last_result = actor.equippable?(item)
    end
    return @@last_result
  end

  # OƑ̔\͌vZ
  def equip_ability_calc(item,actor)
    equip_prev = 0
    equip_next = 0
    case item
    when Game_Weapon, RPG::Weapon
      # O
      equip_prev = actor.atk
      # 
      equip_next = actor.atk + item.atk
      # Ă鑕̒l
      if not actor.weapon.nil?
        equip_next -= actor.weapon.atk
      end
    when Game_Armor, RPG::Armor
      # O
      equip_prev = actor.pdef
      # 
      equip_next = actor.pdef + item.pdef
      # Ă鑕̒l
      if not actor.equip_armors[item.kind].nil?
        equip_next -= actor.equip_armors[item.kind].pdef
      end
    end
    return equip_prev, equip_next
  end

  #--------------------------------------------------------------------------
  # ACe̎擾
  #--------------------------------------------------------------------------
  def equip_items(actor)
    if actor.class.method_defined?('equip_items')
      @@last_result = actor.equip_items
    else
      @@last_result = []
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ĂACeH
  #--------------------------------------------------------------------------
  def actor_equip?(item,actor)
    @@last_result = equip_items(actor).include?(item)
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # Œ肳Ă邩H
  #--------------------------------------------------------------------------
  def equip_fix?(item,actor)
    @@last_result = false
    case item
    when Game_Weapon
      @@last_result = actor.equip_fix?(0)
    when Game_Armor
      @@last_result = actor.equip_fix?(item.kind + 1)
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ACe킽
  #--------------------------------------------------------------------------
  def trade_item(actor1,item1,actor2,item2=nil)
    @@last_result = false
    if item2.nil?
      # n
      lose(item1,actor1)
      gain(item1,actor2)
      @@last_result = true
    elsif item1 != item2
      # 
      lose(item1,actor1)
      lose(item2,actor2)
      gain(item2,actor1)
      gain(item1,actor2)
      @@last_result = true
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ACeĂ
  #--------------------------------------------------------------------------
  def throw_item(item,owner_actor = nil)
    @@last_result = false
    if item_can_throw?(item,owner_actor)
      lose(item,owner_actor)
      @@last_result = true
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ACêĂ邩ǂmF
  #--------------------------------------------------------------------------
  def item_can_throw?(item,owner_actor = nil)
    # 傪܂Ăꍇ́A{ɏĂ邩mFBӂ̏ꍇH
    if not owner_actor.nil?
      if not owner_actor.backpack.include?(item)
        return false
      end
    end

    # iÓ̕uȂ́vibΏj
    if item.price == 0
      return false
    end
    return true
  end

  #--------------------------------------------------------------------------
  # ACegpł邩ǂmF
  #--------------------------------------------------------------------------
  def item_can_use?(use_item,owner_actor = nil,use_actor = nil)
    # 傪܂Ăꍇ́A{ɏĂ邩mFBӂ̏ꍇH
    if not owner_actor.nil?
      if not owner_actor.backpack.include?(use_item)
        @@last_result = false
        return @@last_result
      end
    end

    item = get_use_item(use_item)

    # gpACeł͂Ȃꍇ
    if item.nil?
      @@last_result = false
      return @@last_result
    end

    # gp\擾
    occasion = item.occasion

    # og̏ꍇ
    if $game_temp.in_battle
      # gp\ 0 (펞) ܂ 1 (oĝ) Ȃgp\
      @@last_result = (occasion == 0 or occasion == 1)
    else
      # gp\ 0 (펞) ܂ 2 (j[̂) Ȃgp\
      @@last_result = (occasion == 0 or occasion == 2)
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ACeg
  #--------------------------------------------------------------------------
  def use_item(use_item, owner_actor = nil, use_actors = [])
    result = false
    item = get_use_item(use_item)
    use_actors.each do |actor|
      result |= actor.item_effect item
    end
    # ACegpꂽꍇ
    if result
      # Օȉꍇ
      if item.consumable
        # gpACe 1 炷
        lose(use_item,owner_actor)
      end
      # ogȊȌꍇ
      if not $game_temp.in_battle
        # ACe̎gp SE t
        $game_system.se_play(item.menu_se)
      end
    end
    @@last_result = result
    return result
  end

  # ACeH
  def item?(item)
    return (item.is_a?(RPG::Item) or item.is_a?(Game_Item))
  end

  # 킩H
  def weapon?(item)
    return (item.is_a?(RPG::Weapon) or item.is_a?(Game_Weapon))
  end

  # hH
  def armor?(item)
    return (item.is_a?(RPG::Armor) or item.is_a?(Game_Armor))
  end

  # GameCX^X쐬
  # item:: RPGW[̃ACe
  def create_instance(item)
    case item
    when RPG::Item
      return Game_Item.new(item.id)
    when RPG::Weapon
      return Game_Weapon.new(item.id)
    when RPG::Armor
      return Game_Armor.new(item.id)
    end
    return item
  end

  # ACȇ
  # item:: GameCX^X̃ACe
  # actor:: AN^[ nil ̏ꍇobNpbNɓ
  def gain(item,actor=nil)
    @@last_result = false
    item = create_instance(item)
    if actor.nil?
      $game_party.actors.each do |a|
        @@last_result = a.backpack.add_item item
        break if @@last_result
      end
      if not @@last_result
        @@last_result = $game_party.backpack.add_item item
      end
    else
      @@last_result = actor.backpack.add_item item
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  # ACě
  #--------------------------------------------------------------------------
  def lose(item,actor=nil)
    @@last_result = false
    if actor.nil?
      $game_party.actors.each do |a|
        @@last_result = lose(item,a)
        break if @@last_result
      end
      if not @@last_result
        @@last_result = $game_party.backpack.remove_item(item)
      end
    else
      # ̏ꍇ́AO
      if Item_Facade.actor_equip?(item,actor)
        actor.remove_equip_item(item)
      end
      @@last_result = actor.backpack.remove_item(item)
    end
    return @@last_result
  end

  #--------------------------------------------------------------------------
  #  ACȇ ()
  #     item_id : ACe ID
  #     n       : 
  #     actor   : ACe𑝌AN^[
  #--------------------------------------------------------------------------
  def gain_item(id, n, actor = nil)
    return _gain_item_base(Game_Item, id, n, actor)
  end

  def lose_item(id, n, actor = nil)
    return _gain_item_base(Game_Item, id, -n, actor)
  end

  def gain_weapon(id, n, actor = nil)
    return _gain_item_base(Game_Weapon, id, n, actor)
  end

  def lose_weapon(id, n, actor = nil)
    return _gain_item_base(Game_Weapon, id, -n, actor)
  end

  def gain_armor(id, n, actor = nil)
    return _gain_item_base(Game_Armor, id, n, actor)
  end

  def lose_armor(id, n, actor = nil)
    return _gain_item_base(Game_Armor, id, -n, actor)
  end

  def find_item(klass,id,actor=nil)
    return _find(klass,id,actor)
  end

  #--------------------------------------------------------------------------
  # vCx[g\bh
  #--------------------------------------------------------------------------
  def _gain_item_base(type, id, n, actor = nil)
    for i in 1 .. n.abs
      if 0 < n
        _gain(type,id,actor)
      elsif n < 0
        _lose(type,id,actor)
      end
    end
    return last_result
  end

  # ȊÕACeT
  def _find_no_equip(klass,id,actor)
    find_proc = proc do |item|
      # ĂȂ̂
      if not Item_Facade.actor_equip?(item,actor)
        if item.is_a?(klass) and item.id == id
          return item
        end
      end
    end
    if actor.nil?
      $game_party.actors.each do |a|
        item = _find_no_equip(klass,id,a)
        if not item.nil?
          return item
        end
      end
      $game_party.backpack.each_item(&find_proc)
    else
      actor.backpack.each_item(&find_proc)
    end
    return nil
  end

  # ACeT
  def _find(klass,id,actor)
    find_proc = proc do |item|
      if item.is_a?(klass) and item.id == id
        return item
      end
    end
    if actor.nil?
      $game_party.actors.each do |a|
        item = _find(klass,id,a)
        if not item.nil?
          return item
        end
      end
      $game_party.backpack.each_item(&find_proc)
    else
      actor.backpack.each_item(&find_proc)
    end
    return nil
  end

  def _gain(klass,id,actor)
    return if id == 0
    return gain(klass.new(id),actor)
  end

  def _lose(klass,id,actor)
    item = _find_no_equip(klass,id,actor)
    if item.nil?
      item = _find(klass,id,actor)
    end
    if not item.nil?
      lose(item,actor)
      @@last_result = true
    else
      @@last_result = false
    end
    return @@last_result
  end
end
