#==============================================================================
#  Spriteset_Battle
#------------------------------------------------------------------------------
# cppogʂ̃XvCg
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Battle
    
    class Spriteset_Battle
      #--------------------------------------------------------------------------
      #  JCX^Xϐ
      #--------------------------------------------------------------------------
      attr_reader   :viewport1                # Gl~[̃r[|[g
      attr_reader   :viewport2                # AN^[̃r[|[g
      attr_reader   :dummy_sprite             # _~[XvCg
      #--------------------------------------------------------------------------
      #  IuWFNg
      #--------------------------------------------------------------------------
      def initialize
        # r[|[g쐬
        @viewport1 = Viewport.new(0, 0, 640, 480)
        @viewport2 = Viewport.new(0, 0, 640, 480)
        @viewport3 = Viewport.new(0, 0, 640, 480)
        @viewport4 = Viewport.new(0, 0, 640, 480)
        @viewport1.z = 0
        @viewport2.z = 10000
        @viewport3.z = 200
        @viewport4.z = 5000
        # ogobNXvCg쐬
        @battleback_sprite = Sprite.new(@viewport1)
        # ogobN^Cv
        if Module.constants.include?('BATTLE_BACK_TYPE')
          @battle_back_type = BATTLE_BACK_TYPE
        else
          @battle_back_type = 0
        end
        if Module.constants.include?('BATTLE_BACK_MAP') and (not $BTEST)
          # ogobN}bv쐬
          create_battleback_map
          # ogobN}bvXV
          update_battleback_map
        end
        # Gl~[XvCg쐬
        @enemy_sprites = []
        for enemy in $game_troop.enemies.reverse
          @enemy_sprites.push(Sprite_Battler.new(@viewport1, enemy))
        end
        # _~[XvCg
        @dummy_sprite = Sprite_Battler_Dummy.new(@viewport2)
        @dummy_sprite.bitmap = Bitmap.new(32,32)
        @dummy_sprite.x = 640 / 2 - 32 / 2
        @dummy_sprite.y = 480 / 4 * 3 - 32 / 2
        # V쐬
        @weather = RPG::Weather.new(@viewport1)
        # sN`XvCg쐬
        @picture_sprites = []
        for i in 51..100
          @picture_sprites.push(Sprite_Picture.new(@viewport3,
                                                   $game_screen.pictures[i]))
        end
        # ^C}[XvCg쐬
        @timer_sprite = Sprite_Timer.new
        # t[XV
        update
      end
      #--------------------------------------------------------------------------
      #  
      #--------------------------------------------------------------------------
      def dispose
        # ogobNrbg}bv݂Ă
        if @battleback_sprite.bitmap != nil
          @battleback_sprite.bitmap.dispose
        end
        # ogobNXvCg
        @battleback_sprite.dispose
        if Module.constants.include?('BATTLE_BACK_MAP') and (not $BTEST)
          # ogobN}bv
          dispose_battleback_map
        end
        # Gl~[XvCgAAN^[XvCg
        for sprite in @enemy_sprites
          sprite.dispose
        end
        # _~[XvCg
        @dummy_sprite.dispose
        # V
        @weather.dispose
        # sN`XvCg
        for sprite in @picture_sprites
          sprite.dispose
        end
        # ^C}[XvCg
        @timer_sprite.dispose
        # r[|[g
        @viewport1.dispose
        @viewport2.dispose
        @viewport3.dispose
        @viewport4.dispose
      end
      #--------------------------------------------------------------------------
      #  GtFNg\
      #--------------------------------------------------------------------------
      def effect?
        # GtFNgł\Ȃ true Ԃ
        return true if @dummy_sprite.effect?
        for sprite in @enemy_sprites
          return true if sprite.effect?
        end
        return false
      end
      #--------------------------------------------------------------------------
      #  t[XV
      #--------------------------------------------------------------------------
      def update
        # ogobÑt@Ĉ݂̂ƈႤꍇ
        if @battleback_name != $game_temp.battleback_name
          @battleback_name = $game_temp.battleback_name
          if @battleback_sprite.bitmap != nil
            @battleback_sprite.bitmap.dispose
          end
          battleback = RPG::Cache.battleback(@battleback_name)
          case @battle_back_type
          when 1
            # ㉺
            @battleback_sprite.bitmap = battleback
            @battleback_sprite.y = 240 - battleback.height / 2
          else
            # L΂
            @battleback_sprite.bitmap = Bitmap.new(640,480)
            @battleback_sprite.bitmap.stretch_blt(Rect.new(0,0,640,480),battleback,battleback.rect)
            @battleback_sprite.src_rect.set(0, 0, 640, 480)
          end
        end
        # og[XvCgXV
        for sprite in @enemy_sprites
          sprite.update
        end
        for actor in $game_party.actors
          if @dummy_sprite.animation_id == 0
            @dummy_sprite.animation_id = actor.animation_id
            @dummy_sprite.animation_hit = actor.animation_hit
            actor.animation_id = 0
            actor.animation_hit =  0
          end
        end
        # _~[XvCg
        @dummy_sprite.update
        # VOtBbNXV
        @weather.type = $game_screen.weather_type
        @weather.max = $game_screen.weather_max
        @weather.update
        # sN`XvCgXV
        for sprite in @picture_sprites
          sprite.update
        end
        # ^C}[XvCgXV
        @timer_sprite.update
        # ʂ̐FƃVFCNʒuݒ
        @viewport1.tone = $game_screen.tone
        @viewport1.ox = $game_screen.shake
        # ʂ̃tbVFݒ
        @viewport4.color = $game_screen.flash_color
        # r[|[gXV
        @viewport1.update
        @viewport2.update
        @viewport4.update
      end
      
      # ogobN}bv쐬
      def create_battleback_map
        @viewport_battleback_map = Viewport.new(0, 0, 640, 480)
        @viewport_battleback_map.z = -100
        @viewport_battleback_map.tone = Tone.new(-64,-64,-64)
        @tilemap = Tilemap.new(@viewport_battleback_map)
        @tilemap.tileset = RPG::Cache.tileset($game_map.tileset_name)
        for i in 0..6
          autotile_name = $game_map.autotile_names[i]
          @tilemap.autotiles[i] = RPG::Cache.autotile(autotile_name)
        end
        @tilemap.map_data = $game_map.data
        @tilemap.priorities = $game_map.priorities
        # pm}v[쐬
        @panorama = Plane.new(@viewport_battleback_map)
        @panorama.z = -1000
      end
      
      # ogobN}bvXV
      def update_battleback_map
        @tilemap.ox = $game_map.display_x / 4
        @tilemap.oy = $game_map.display_y / 4
        @tilemap.update
        # pm}݂̂̂ƈقȂꍇ
        if @panorama_name != $game_map.panorama_name or
          @panorama_hue != $game_map.panorama_hue
          @panorama_name = $game_map.panorama_name
          @panorama_hue = $game_map.panorama_hue
          if @panorama.bitmap != nil
            @panorama.bitmap.dispose
            @panorama.bitmap = nil
          end
          if @panorama_name != ""
            @panorama.bitmap = RPG::Cache.panorama(@panorama_name, @panorama_hue)
          end
          Graphics.frame_reset
        end
      end
      
      # ogobN}bv
      def dispose_battleback_map
        @tilemap.tileset.dispose
        for i in 0..6
          @tilemap.autotiles[i].dispose
        end
        @tilemap.dispose
        @panorama.dispose
        @viewport_battleback_map.dispose
      end
      
    end
    
  end
end
