# ݒt@CpW[
# Author:: fukuyama
# Date:: 2006/11/18
# Copyright:: Copyright (c) 2005,2006 rgss-lib.sourceforge.jp

module RGSS_LIB_Utils
  module_function
  
  @@properties = {}
  
  def load_properties(data_filename)
    if not @@properties.include?(data_filename)
      @@properties[data_filename] = load_data(data_filename)
    end
    return @@properties[data_filename]
  end
  
  def compile_properties(properties_filename,data_filename)
    return if not $DEBUG
    data_properties = {}
    if not FileTest.file?(data_filename)
      save_data(data_properties,data_filename)
    end
    if not FileTest.file?(properties_filename)
      return
    end
    data_properties = {}
    File.open(properties_filename) do |file|
      file.each_line do |line|
        next if line =~ /^#/
        line[/\s$/] = ''
        next if line.empty?
         (key,val) = line.split(/\s*=\s*/)
        next if val.nil?
        if val == '""'
          data_properties[key] = ''
        else
          data_properties[key] = val
        end
      end
    end
    save_data(data_properties,data_filename)
  end
end
