#==============================================================================
#  Markup_Items
#------------------------------------------------------------------------------
# }[NAbvACe
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \item[id]  whc̃ACe\
# \weapon[id]  whc̕\
# \armor[id]  whc̖h\
# ӁFʒ[ŕ\Ɛhc
#
#==============================================================================

module Markup_Item
  module_function
  def query
    return /\\item\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    text[query] = "\\item.img\[#{id}\]\\item.nm\[#{id}\]"
  end
end

module Markup_Weapon
  module_function
  def query
    return /\\weapon\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    text[query] = "\\weapon.img\[#{id}\]\\weapon.nm\[#{id}\]"
  end
end

module Markup_Armor
  module_function
  def query
    return /\\armor\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    text[query] = "\\armor.img\[#{id}\]\\armor.nm\[#{id}\]"
  end
end

String_Replace_Module.add_markup(Markup_Item)
String_Replace_Module.add_markup(Markup_Weapon)
String_Replace_Module.add_markup(Markup_Armor)

module Markup_Item_Name
  module_function
  def query
    return /\\item[\._]nm\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    item = $data_items[id]
    text[query] = item.name
  end
end

module Markup_Weapon_Name
  module_function
  def query
    return /\\weapon[\._]nm\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    item = $data_weapons[id]
    text[query] = item.name
  end
end

module Markup_Armor_Name
  module_function
  def query
    return /\\armor[\._]nm\[([0-9]+)\]/
  end

  def transfer(obj, text, match)
    id = match[1].to_i
    item = $data_armors[id]
    text[query] = item.name
  end
end

String_Replace_Module.add_markup(Markup_Item_Name)
String_Replace_Module.add_markup(Markup_Weapon_Name)
String_Replace_Module.add_markup(Markup_Armor_Name)
