#==============================================================================
#  Markup_Font_Type
#------------------------------------------------------------------------------
# }[NAbvtHg^Cv
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \FN[tHg]  tHgύXiwtHgɒǉj
# \FC[tHg]  tHg폜iwtHg₩폜j
# \B               tHg{[ĥɂigOj
# \I               tHgC^bN̂ɂigOj
#
#==============================================================================

module Markup_Font_Name
  module_function
  def query
    return /^\\FN\[([^\]]*)\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.name.delete(match[1])
    bmp.font.name = [match[1],*bmp.font.name]
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Name)

module Markup_Font_Clear
  module_function
  def query
    return /^\\FC\[([^\]]*)\]/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.name.delete(match[1])
    bmp.font.name = bmp.font.name
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Clear)

module Markup_Font_Bold
  module_function
  def query
    return /^\\B/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.bold = ! bmp.font.bold
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Bold)

module Markup_Font_Italic
  module_function
  def query
    return /^\\I/
  end
  def transfer(bmp, x, y, text, match)
    bmp.font.italic = ! bmp.font.italic
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Italic)
