#==============================================================================
#  FuzzySet
#------------------------------------------------------------------------------
# t@W[WNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class FuzzySet
  attr_accessor :create_fuzzy_labels
  attr_reader :labels
  def initialize
    @fuzzy_data = {}
    @fuzzy_result = {}
    @labels = []
    @create_fuzzy_labels = nil
  end
  def clear
    @fuzzy_data.clear
    @fuzzy_result.clear
    @labels.clear
  end
  def adjust_right(x0,x1,adjust)
    return x1 - (x1 - x0) * adjust
  end
  def adjust_left(x0,x1,adjust)
    return x0 + (x1 - x0) * adjust
  end
  def create_fuzzy(i,*arg)
    f = Fuzzy.new(*arg)
    f.name = @create_fuzzy_labels[i].to_s if not @create_fuzzy_labels.nil?
    return f
  end
  def create_fuzzy_labels(labels=nil)
    @create_fuzzy_labels = labels unless labels.nil?
    return @create_fuzzy_labels
  end
  def create_fuzzy_set(points,amp=0.1,overlap=0.0)
    self.clear
    values = points.sort.collect {|i| i.to_f}
    
    prev_value = values[0]
    next_value = values[1]
    
    s = adjust_left(prev_value,next_value,amp)
    e = adjust_right(prev_value,next_value,amp)
    e = adjust_right(prev_value,e,overlap)
    
    self.push create_fuzzy(0,e,s)
    
    i = 0
    for i in 1 ... (values.size-1)
      current_value = values[i]
      next_value = values[i + 1]
      
      x0 = adjust_left(prev_value,current_value,amp)
      x0 = adjust_left(x0,current_value,overlap)
      x1 = adjust_right(prev_value,current_value,amp)
      x2 = adjust_left(current_value,next_value,amp)
      x3 = adjust_right(current_value,next_value,amp)
      x3 = adjust_right(current_value,x3,overlap)
      
      self.push create_fuzzy(i,x0,x1,x2,x3)
      
      prev_value = current_value
    end
    
    s = adjust_left(prev_value,next_value,amp)
    s = adjust_left(s,next_value,overlap)
    e = adjust_right(prev_value,next_value,amp)
    
    next_value = values.last
    
    self.push create_fuzzy(i+1,s,e)
    
  end
  def push(v,*args)
    case v
    when String
      f = Fuzzy.new(*args)
      f.name = v
      @fuzzy_data[f.name] = f
      @labels.push f.name
    when Fuzzy
      if v.name.empty?
        v.name = sprintf('Fuzzy%03d', @fuzzy_data.size)
      end
      @fuzzy_data[v.name] = v
      @labels.push v.name
    end
  end
  def [](name)
    @fuzzy_result[name]
  end
  def member_ship(v)
    @fuzzy_result.clear
    @fuzzy_data.each_value do |item|
      @fuzzy_result[item.name] = item * v
    end
  end
  def result_name
    values = labels.collect {|i| self[i]}
    labels[values.index(values.max)]
  end
  def set(fs_data_list)
    keys = []
    values = []
    fs_data_list.each do |fs_data|
      keys.push fs_data[0]
      values.push fs_data[1]
    end
    self.create_fuzzy_labels = keys
    self.create_fuzzy_set(values)
  end
end
