#==============================================================================
#  FuzzyMatrix
#------------------------------------------------------------------------------
# t@W[}gNX
# Copyright (C) 2005 fukuyama
#==============================================================================

class FuzzyMatrix < MatrixBase
  attr_reader :result
  def initialize(fuzzy_set_list)
    @fuzzy_set_list = fuzzy_set_list
    super(@fuzzy_set_list.size,@fuzzy_set_list[0].labels.size)
    @result = {}
  end
  def initialize_label
    dimensionlabel = []
    for i in 0 ... @dimension
      dimensionlabel.push @fuzzy_set_list[i].labels
    end
    return dimensionlabel
  end
  def member_ship(values)
    values.each_index do |i|
      @fuzzy_set_list[i].member_ship(values[i])
    end
    member_ship_map = {}
    each_index do |*index|
      matrix_member_ship_list = []
      index.each_index do |i|
        fs = @fuzzy_set_list[i]
        matrix_member_ship_list.push fs[fs.labels[index[i]]]
      end
      n = 1
      index.each {|i| n += i}
      unless member_ship_map.include? n
        member_ship_map[n] = []
      end
      member_ship_map[n].push Fuzzy.and(*matrix_member_ship_list)
    end
    member_ship_map.keys.sort.each do |k|
      @result[k] = Fuzzy.or(*member_ship_map[k])
    end
  end
  def score(*list)
    self.member_ship(list)
    v = 0
    t = 0
    self.result.keys.sort.each do |key|
      v += key * self.result[key]
      t += self.result[key]
    end
    return (v / t) / self.result.size
  end
end
