#==============================================================================
#  FuzzyData
#------------------------------------------------------------------------------
# t@W[f[^
# Copyright (C) 2005 fukuyama
#==============================================================================

class FuzzyData
  attr_reader :source
  
  def initialize(source)
    @source = source
    @fuzzy = {}
  end
  
  def create_fuzzy_set(name,label_list,value_list,member_ship=nil)
    set_list = []
    if block_given?
      for i in 0 ... label_list.size
        set_list.push yield(@source,label_list[i],value_list[i])
      end
    else
      set_list = value_list
    end
    fs = FuzzySet.new
    fs.create_fuzzy_labels(label_list)
    fs.create_fuzzy_set(set_list)
    @fuzzy[name] = fs
    self.member_ship(name,member_ship) unless member_ship.nil?
  end
  
  def member_ship(name,member_ship)
    @fuzzy[name].member_ship(member_ship)
  end
  
  def match?(name,label)
    rv = false
    case label
    when Array
      label.each do |l|
        rv = (@fuzzy[name].result_name == l)
        if rv
          break
        end
      end
    else
      rv = (@fuzzy[name].result_name == label)
    end
    return rv
  end
  def [](name,label)
    return @fuzzy[name][label]
  end
end
