#==============================================================================
#  Fuzzy
#------------------------------------------------------------------------------
# t@W[
# Copyright (C) 2005 fukuyama
#==============================================================================

class Fuzzy
  attr_accessor :name
  
  def initialize(*x)
    @name = ''
    @membership_function = nil
    @x = []
    if x.size == 2
      if x[0] < x[1]
        @membership_function = :grade
        @x[0],@x[1]=x[0].to_f,x[1].to_f
      elsif x[1] < x[0]
        @membership_function = :reverse_grade
        @x[0],@x[1]=x[1].to_f,x[0].to_f
      end
    elsif x.size == 3
      @membership_function = :traiangle
      x.sort.each {|n| @x.push n.to_f }
    elsif x.size == 4
      @membership_function = :trapezoid
      x.sort.each {|n| @x.push n.to_f }
    end
  end
  def *(v)
    r = 0.0
    if not @membership_function.nil?
      r = method(@membership_function).call(v)
    end
    return r
  end
  def intarnal_grade(x,x0,x1)
    m = x1 - x0
    x / m - x0 / m
  end
  def intarnal_reverse_grade(x,x0,x1)
    m = x1 - x0
    -x / m + x1 / m
  end
  def grade(v)
    x = v.to_f
    r = 0.0
    if x <= @x[0]
      r = 0.0
    elsif @x[1] <= x
      r = 1.0
    else
      r = intarnal_grade(x, @x[0], @x[1])
    end
    return r
  end
  def reverse_grade(v)
    x = v.to_f
    r = 0.0
    if x <= @x[0]
      r = 1.0
    elsif @x[1] <= x
      r = 0.0
    else
      r = intarnal_reverse_grade(x, @x[0], @x[1])
    end
    return r
  end
  def traiangle(v)
    x = v.to_f
    r = 0.0
    if x <= @x[0]
      r = 0.0
    elsif @x[1] == x
      r = 1.0
    elsif @x[2] <= x
      r = 0.0
    elsif @x[0] < x and x < @x[1]
      r = intarnal_grade(x, @x[0], @x[1])
    else
      r = intarnal_reverse_grade(x, @x[1], @x[2])
    end
    return r
  end
  def trapezoid(v)
    x = v.to_f
    r = 0.0
    if x <= @x[0]
      r = 0.0
    elsif @x[1] <= x and x <= @x[2]
      r = 1.0
    elsif @x[3] <= x
      r = 0.0
    elsif @x[0] < x and x < @x[1]
      r = intarnal_grade(x, @x[0], @x[1])
    else
      r = intarnal_reverse_grade(x, @x[2], @x[3])
    end
    return r
  end
  def self.and(*arg)
    arg.min
  end
  def self.or(*arg)
    arg.max
  end
  def self.not(a)
    1.0 - a
  end
end
