# ^[QbgXe[^XEBhE\郂W[
# Author:: fukuyama
# Date:: 2011/04/10
# Copyright:: Copyright (c) 2011 rgss-lib

class Window_Page_Menu < Window_Base
  include Event_Handling_Module
  include Window_Menu_Module

  TITLE_HEIGHT = 1.2
  DEFAULT_ITEM_HEIGHT = 32
  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def initialize(*arg)
    super(0, 0, 0, 0)
    @decision_se_off = false if @decision_se_off.nil?

    @item_max = 1 if @item_max.nil?

    if @column_max.nil?
      if not @row_max.nil?
        @column_max = (@menus.size + @row_max - 1) / @row_max
      else
        @column_max = 1
      end
    end

    @cellspacing = Rect.new(4,0,4,0) if @cellspacing.nil?
    @item_height = DEFAULT_ITEM_HEIGHT if @item_height.nil?

    pack
  end

  #---------------------------------------------------------------------------
  # EBhEpbNiTCY𒲐j
  #---------------------------------------------------------------------------
  def pack
    make_contents
    self.width = self.contents.width + 32
    self.height= self.contents.height + 32
    refresh
  end

  #--------------------------------------------------------------------------
  #  J[\ʒu̐ݒ
  #     index : VJ[\ʒu
  #--------------------------------------------------------------------------
  def index=(index)
    @index = index
    # J[\̋`XV
    update_cursor_rect
  end

  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def input_c
    if event_handling_trigger?
      decision_se unless @decision_se_off
      menu_call(@index)
    end
  end

  #---------------------------------------------------------------------------
  # LZ
  #---------------------------------------------------------------------------
  def input_b
    if event_handling_trigger?
      cancel_se
      if not disposed?
        dispose
      end
    end
  end

  #---------------------------------------------------------------------------
  # J[\ړ
  #---------------------------------------------------------------------------
  def input_up
    return if @index < 0
    return if page_item_max == 0
    page,index = @index.divmod page_item_max
    if (index < @column_max and Input.trigger?(Input::UP)) or index >= @column_max
      $game_system.se_play($data_system.cursor_se)
      index = (index - @column_max + page_item_max) % page_item_max
      @index = page * page_item_max + index
      if @index >= @item_max
        @index = @item_max - 1
      end
    end
  end

  def input_down
    return if @index < 0
    return if page_item_max == 0
    page,index = @index.divmod page_item_max
    bottom_line_index = page_item_max - @column_max
    if (index >= bottom_line_index and Input.trigger?(Input::DOWN)) or index < bottom_line_index
      # J[\Ɉړ
      $game_system.se_play($data_system.cursor_se)
      index = (index + @column_max) % page_item_max
      @index = page * page_item_max + index
      if @index >= @item_max
        @index = page * page_item_max
      end
    end
  end

  def input_right
    return if @index < 0
    return if page_item_max == 0
    page,index = @index.divmod page_item_max
    if ((index + 1) % @column_max == 0 and Input.trigger?(Input::RIGHT)) or ((index + 1) % @column_max != 0)
      # J[\EɈړ
      $game_system.se_play($data_system.cursor_se)
      # y[W
      page_max,index_max = (@item_max - 1).divmod page_item_max
      if ((index + 1) % @column_max == 0) and (@index < page_max * page_item_max)
        index += page_item_max
      end
      row, index = index.divmod @column_max
      index = row * @column_max + (index + 1) % @column_max
      @index = page * page_item_max + index
      if @index >= @item_max
        @index = @item_max - 1
      end
    end
  end

  def input_left
    return if @index < 0
    return if page_item_max == 0
    page,index = @index.divmod page_item_max
    if (index % @column_max == 0 and Input.trigger?(Input::LEFT)) or (index % @column_max != 0)
      # J[\Ɉړ
      $game_system.se_play($data_system.cursor_se)
      # y[W
      if (index % @column_max == 0) and (@index >= page_item_max)
        index -= page_item_max
      end
      row, index = index.divmod @column_max
      index = row * @column_max + (index - 1 + @column_max) % @column_max
      @index = page * page_item_max + index
      if @index >= @item_max
        @index = @item_max - 1
      end
    end
  end

  #--------------------------------------------------------------------------
  # tbV
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear

    # Rec蒼Kv邩mF
    page_max = 1
    if not @menus.empty?
      page_max = (@menus.size + page_item_max - 1)/ page_item_max
    end
    w = _contents_width * page_max
    if w != self.contents.width
      h = _contents_height
      self.contents.dispose
      self.contents = Bitmap.new(w,h)
    end

    # ^Cg̕`
    if not @title.nil?
      draw_title(normal_color)
    end
    refresh_menus()
  end

  def refresh_menus
    # j[̕`
    for index in 0...@menus.size
      draw_menu(index, normal_color)
    end
  end

  #--------------------------------------------------------------------------
  # ڂ̍W
  #--------------------------------------------------------------------------
  def menu_rect(index)
    w = _menu_width
    h = _menu_height
    page, index = index.divmod page_item_max
    x = index % @column_max * w + page * _contents_width
    y = index / @column_max * h + _title_height
    return Rect.new(x,y,w,h)
  end

  #--------------------------------------------------------------------------
  # ^Cg̕`
  #--------------------------------------------------------------------------
  def draw_title(color)
    if @title_align.nil?
      @title_align = 0
    end
    # ڂ̍WvZ
    w = _title_width
    h = _menu_height
    y = 0
    page_max, m = @menus.size.divmod page_item_max
    page_max += 1 if m != 0
    for page in 0 .. page_max
      x = page * _contents_width
      rect = Rect.new(x,y,w,h)
      rect.width  -= @cellspacing.x + @cellspacing.width
      rect.height -= @cellspacing.y + @cellspacing.height
      rect.x += @cellspacing.x
      rect.y += @cellspacing.y
      draw_title_item(color,rect,@title,@title_align)
    end
  end

  #--------------------------------------------------------------------------
  # ^Cg̕`iftHgj
  #--------------------------------------------------------------------------
  def draw_title_item(color,rect,title,title_align)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, title, title_align)
  end

  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu(index, color)
    return if index >= @menus.size
    # ڂ̍WvZ
    rect = menu_rect(index)
    rect.width  -= @cellspacing.x + @cellspacing.width
    rect.height -= @cellspacing.y + @cellspacing.height
    rect.x += @cellspacing.x
    rect.y += @cellspacing.y
    draw_menu_item(index,color,rect,@menus[index].name)
  end

  #--------------------------------------------------------------------------
  # ڂ̕`iftHgj
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,name)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, name)
  end

  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    return if self.disposed?
    return if self.contents.nil?
    # J[\ʒu 0 ̏ꍇ
    if @index < 0
      self.cursor_rect.empty
      return
    end
    return if page_item_max == 0
    # ڂ̍WvZ
    page, i = @index.divmod page_item_max
    self.ox = page * _contents_width
    rect = menu_rect(i)

    # J[\̋`XV
    self.cursor_rect = rect
  end

  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    return if self.disposed?
    super
    return if self.disposed?
    if self.active and @prev_active
      update_all_handler if self.active
    else
      update_handler
      @prev_active = self.active
    end
    return if self.disposed?
    # J[\̋`XV
    update_cursor_rect
  end

  #--------------------------------------------------------------------------
  #  1 y[Wɕ\łs̎擾
  #--------------------------------------------------------------------------
  def page_row_max
    if @row_max.nil?
      return (@menus.size + @column_max - 1) / @column_max
    end
    return @row_max
  end

  #--------------------------------------------------------------------------
  #  1 y[Wɕ\ł鍀ڐ̎擾
  #--------------------------------------------------------------------------
  def page_item_max
    # s page_row_max   @column_max |
    return page_row_max * @column_max
  end

  #---------------------------------------------------------------------------
  # Recrbg}bv̍쐬
  def make_contents
    if not self.contents.nil?
      self.contents.dispose
      self.contents = nil
    end
    w = _contents_width
    h = _contents_height
    return if w == 0 or h == 0
    self.contents = Bitmap.new(w,h)
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    if @_contents_width.nil?
      name_test = Bitmap.new(640,@item_height)
      max_width = 0
      @menus.each do |menu|
        max_width = [max_width,name_test.text_size(menu.name).width].max
      end
      max_width += @cellspacing.x + @cellspacing.width
      max_width *= @column_max
      if not @title.nil?
        max_width = [max_width,name_test.text_size(@title).width + @cellspacing.x + @cellspacing.width].max
      end
      name_test.dispose
      @_contents_width = max_width
    end
    return @_contents_width
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_height
    return _menu_height * page_row_max + _title_height
  end

  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_height
    return @item_height + @cellspacing.y + @cellspacing.height
  end

  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return self.contents.width / @column_max
  end

  #---------------------------------------------------------------------------
  # ^Cg̍쐬
  def _title_height
    if @title.nil?
      return 0
    end
    return _menu_height * TITLE_HEIGHT
  end

  #---------------------------------------------------------------------------
  # ^Cg̍쐬
  def _title_width
    if @title.nil?
      return 0
    end
    if @menus.size <= page_item_max
      return self.contents.width
    else
      return (_menu_width / @column_max).to_i
    end
  end
end
