#==============================================================================
#  Window_InputString
#------------------------------------------------------------------------------
# ͗pEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

class Window_InputString < Window_Base
  attr_reader :window_input_area
  attr_reader :end_status
  attr_accessor :auto_dispose
  # 
  def initialize(title,count)
    @end_status = nil
    @auto_dispose = true
    @title = title
    @stringmap = [
      [
      ['','','','','','','','','','','','','','',''],
      ['','','','','','','','','','','','','','',''],
      ['','','','','','','','','','','','','','',''],
      ['','','','','','','','','','','','','','',''],
      ['','','','','','','','','','','','','','',''],
      ['','','','','','[','D','c','H','I','`','@','@','@','@']
      ],[
      ['A','C','E','G','I','n','q','t','w','z','K','M','O','Q','S'],
      ['J','L','N','P','R','}','~','','','','U','W','Y','[',']'],
      ['T','V','X','Z','\','','','','','','_','a','d','f','h'],
      ['^','`','c','e','g','','','','','','o','r','u','x','{'],
      ['i','j','k','l','m','','','','b','','p','s','v','y','|'],
      ['@','B','D','F','H','[','D','c','H','I','','@','@','@','@']
      ],[
      ['`','a','b','c','d','','','','','','P','Q','R','S','T'],
      ['e','f','g','h','i','','','','','','U','V','W','X','O'],
      ['j','k','l','m','n','','','','','','|','{','','~',''],
      ['o','p','q','r','s','','','','','','','','','b',''],
      ['t','u','v','w','x','','','','','','','','','',''],
      ['y','@','@','@','@','','D','A','C','Q','G','F','H','I','`']
      ]
    ]
    @modelist = ['','Ji','p']
    @mode = 0
    @cursor_x = 0
    @cursor_y = 0
    @window_input_area = Window_InputArea.new(count)
    super(16,128,640-32,32*7+32)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    refresh
  end

  # 폜[hH
  def auto_dispose?
    @auto_dispose
  end

  # IXe[^XNA
  def end_status_clear
    @end_status = nil
  end

  # LZꂽH
  def cancel?
    @end_status == 'cancel'
  end

  # ͂ꂽH
  def input?
    @end_status == 'input'
  end

  # ̓f[^̎擾
  def text
    return @window_input_area.text
  end

  # ĕ`
  def refresh
    if @mode < 0
      @mode = @modelist.size - 1
    end
    if @mode >= @modelist.size
      @mode = 0
    end

    self.contents.clear

    # ^Cg
    rect = self.contents.rect
    rect.height = 32
    self.contents.draw_text(rect,@title,1)

    # j[
    rect.x = 532
    rect.width = 44
    rect.y += 32
    self.contents.draw_text(rect,@modelist[(@mode + 1)%@modelist.size],1)
    rect.y += 32
    self.contents.draw_text(rect,'߂',1)
    rect.y += 32
    self.contents.draw_text(rect,'I',1)

    # L[{[h
    rect = Rect.new(4,32,32,32)
    @stringmap[@mode].each do |strings|
      i = 0
      strings.each do |string|
        i += 1
        self.contents.draw_text(rect,string,1)
        rect.x += 32
        if (i % 5) == 0
          rect.x += 16
        end
      end
      rect.y += 32
      rect.x = 4
    end
  end

  def cursor_index_check
    if @cursor_x < 0 or @cursor_y < 0
      return false
    end
    if @cursor_x == 15 and [0,1,2].include?(@cursor_y)
      return true
    end
    if @cursor_x >= 15 or @cursor_y >= 6
      return false
    end
    return true
  end

  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    if @cursor_x == 15 and [0,1,2].include?(@cursor_y)
      x = 532
      y = @cursor_y * 32 + 32
      self.cursor_rect.set(x - 4, y, 44 + 8, 32)
    else
      x = @cursor_x * 32 + 4
      x += 16 if @cursor_x >= 5
      x += 16 if @cursor_x >= 10
      y = @cursor_y * 32 + 32
      self.cursor_rect.set(x, y, 32, 32)
    end
  end

  #--------------------------------------------------------------------------
  # xg
  #--------------------------------------------------------------------------
  def event_decision
    if @cursor_x == 15
      case @cursor_y
      when 0 # [hύX
        decision_se
        @mode += 1
        refresh
      when 1 # ߂
        event_cancel
      when 2 # I
        decision_se
        if self.auto_dispose?
          dispose
        end
        if @window_input_area.empty?
          @end_status = 'cancel'
        else
          @end_status = 'input'
        end
      end
    else
      decision_se
      @window_input_area.add_char @stringmap[@mode][@cursor_y][@cursor_x]
      if @window_input_area.max?
        # tɂȂuIv
        @cursor_x = 15
        @cursor_y = 2
      end
    end
  end

  #--------------------------------------------------------------------------
  # LZCxg
  #--------------------------------------------------------------------------
  def event_cancel
    cancel_se
    if @window_input_area.empty?
      if self.auto_dispose?
        # 󂾂
        dispose
      end
      @end_status = 'cancel'
    else
      # ꕶ폜
      @window_input_area.del_char
    end
  end

  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    if Input.trigger? Input::B
      event_cancel
      return
    end
    if Input.trigger? Input::C
      event_decision
      return
    end
    if Input.repeat? Input::UP
      @cursor_y -= 1
      if not cursor_index_check
        if @cursor_x == 15
          @cursor_y = 2
        else
          @cursor_y = 5
        end
      end
      cursor_se
    end
    if Input.repeat? Input::DOWN
      @cursor_y += 1
      if not cursor_index_check
        @cursor_y = 0
      end
      cursor_se
    end
    if Input.repeat? Input::LEFT
      @cursor_x -= 1
      if not cursor_index_check
        if [0,1,2].include?(@cursor_y)
          @cursor_x = 15
        else
          @cursor_x = 14
        end
      end
      cursor_se
    end
    if Input.repeat? Input::RIGHT
      @cursor_x += 1
      if not cursor_index_check
        @cursor_x = 0
      end
      cursor_se
    end
    update_cursor_rect
    super
    @window_input_area.update
  end

  #--------------------------------------------------------------------------
  # EBhEj
  #--------------------------------------------------------------------------
  def dispose
    Input.update
    super
    @window_input_area.dispose
  end

  def visible=(v)
    super(v)
    @window_input_area.visible = v
  end
end

#==============================================================================
#  Event_Script
#------------------------------------------------------------------------------
# CxgXNvgp
#==============================================================================

module Event_Script
  @@window_input_string = nil
  @@input_string_result = ''

  module_function
  def input_string(title,length=4)
    if @@window_input_string.nil?
      @@window_input_string = Window_InputString.new(title,length)
    elsif @@window_input_string.disposed?
      @@input_string_result = @@window_input_string.text
      @@window_input_string = nil
      return true
    else
      @@window_input_string.update
    end
    return false
  end

  def input_string_result
    return @@input_string_result
  end
end
