# VXef[^[hW[
# Author:: fukuyama
# Date:: 2007/10/13
# Copyright:: Copyright (c) 2005-2007 fukuyama

module Data_Loader
  module_function
  # }bv
  def data_map_infos
    if $data_map_infos.nil?
      $data_map_infos = load_data("Data/MapInfos.rxdata")
    end
    return $data_map_infos
  end

  # AN^[
  def data_actors
    if $data_actors.nil?
      $data_actors = load_data("Data/Actors.rxdata")
    end
    return $data_actors
  end

  # NX
  def data_classes
    if $data_classes.nil?
      $data_classes = load_data("Data/Classes.rxdata")
    end
    return $data_classes
  end

  # XL
  def data_skills
    if $data_skills.nil?
      $data_skills = load_data("Data/Skills.rxdata")
    end
    return $data_skills
  end

  # ACe
  def data_items
    if $data_items.nil?
      $data_items = load_data("Data/Items.rxdata")
    end
    return $data_items
  end

  # 
  def data_weapons
    if $data_weapons.nil?
      $data_weapons = load_data("Data/Weapons.rxdata")
    end
    return $data_weapons
  end

  # h
  def data_armors
    if $data_armors.nil?
      $data_armors = load_data("Data/Armors.rxdata")
    end
    return $data_armors
  end

  # Gl~[
  def data_enemies
    if $data_enemies.nil?
      $data_enemies = load_data("Data/Enemies.rxdata")
    end
    return $data_enemies
  end

  # g[v
  def data_troops
    if $data_troops.nil?
      $data_troops = load_data("Data/Troops.rxdata")
    end
    return $data_troops
  end

  # Xe[g
  def data_states
    if $data_states.nil?
      $data_states = load_data("Data/States.rxdata")
    end
    return $data_states
  end

  # Aj[V
  def data_animations
    if $data_animations.nil?
      $data_animations = load_data("Data/Animations.rxdata")
    end
    return $data_animations
  end

  # ^CZbg
  def data_tilesets
    if $data_tilesets.nil?
      $data_tilesets = load_data("Data/Tilesets.rxdata")
    end
    return $data_tilesets
  end

  # RCxg
  def data_common_events
    if $data_common_events.nil?
      $data_common_events = load_data("Data/CommonEvents.rxdata")
    end
    return $data_common_events
  end

  # VXef[^
  def data_system
    if $data_system.nil?
      $data_system = load_data("Data/System.rxdata")
    end
    return $data_system
  end

  # ėpf[^ǗpCX^X key = rxdata file name / value = rxdata
  $data_section_map = {}

  # ėpf[^
  def data_section_map(rxfile,txtfile=nil)
    if txtfile.nil?
      txtfile = rxfile + '.txt'
      rxfile = "Data/#{rxfile}.rxdata"
    end
    if $data_section_map.include? rxfile
      return $data_section_map[rxfile]
    end
    # fobN̏ꍇ
    if $DEBUG
      # f[^
      data = []
      # x[XfBNg
      base_dir = ['./','csv/','Data/','Data/csv/']
      base_dir = BASE_DIR if defined? BASE_DIR
      # t@C̑݃`FbN
      txtfolder = base_dir.find {|folder| FileTest.exist?(folder + txtfile)}
      if not txtfolder.nil?
        param = {}
        # p[^[ǂݍ
        IO.foreach(txtfolder + txtfile) do |line|
          next if line =~ /^#/
          line = line.strip
          if line =~ /^\[(.*?)\]$/
            # ZNV
            param = {}
            param['section'] = $1
            data.push param
          elsif line =~ /^\s*(.*?)\s*=\s*(-?[0-9]*?)\s*$/
            # l
            param[$1] = $2.to_i
          elsif line =~ /^\s*(.*?)\s*=\s*(.*?)\s*$/
            # 
            param[$1] = $2.to_s
          elsif line =~ /^\s*(.+?)\s*$/
            # ^Ul
            param[$1] = true
          end
        end
      end
      # f[^
      save_data(data, rxfile)
    end
    # f[^ǂݍ
    $data_section_map[rxfile] = load_data(rxfile)
    return $data_section_map[rxfile]
  end

  # RpCIuWFNg
  #
  # fobNɁACSV t@CRpCArxdata쐬B
  # CSVf[^̃p[Xɂ́ApParser::Parser_BasehAp[XNX𗘗pB
  #
  # name:: IuWFNgNX
  # options:: RpCIvVB
  # parser=Ɏgpp[T[
  # filename=ǂݍރt@CύXꍇɎw
  def compile_object(name,options={})
    filename = name
    filename = options['filename'] if options.include? 'filename'
    rxdata_filename = 'Data/' + filename + '.rxdata'
    unless $DEBUG
      # fobNł͖ꍇ́Af[^[h
      return load_data(rxdata_filename)
    end

    # x[XfBNg
    base_dir = ['./','csv/','Data/','Data/csv/']
    base_dir = BASE_DIR if defined? BASE_DIR
    if options.include?('base_dir')
      dir = options['base_dir']
      if not dir.nil?
        if dir.is_a?(Array)
          base_dir.push(*dir)
        else
          base_dir.push(dir)
        end
      end
    end

    # t@C݂̑ꏊT
    folder = base_dir.find {|folder| FileTest.exist?(folder + filename + '.csv')}
    unless folder.nil?
      # ʊi[pCX^X
      results = []
      if options.include? 'data_type'
        case options['data_type']
        when 'map'
          results = {}
        end
      end
      # t@C쐬
      filename = folder + filename + '.csv'
      compile_object_internal(results,name,filename,options)
      save_data(results,rxdata_filename)
    end
    return load_data(rxdata_filename)
  end

  def compile_object_internal(results,name,filename,options)
    # p[T[
    parser = nil
    parser = options['parser'] if options.include? 'parser'
    parser = eval('Parser::' + name + '_Parser.new') if parser.nil?
    # t@CI[v
    IO.foreach(filename) do |line|
      line.strip!

      # RgƋ󔒍s̃`FbN
      next if line =~ /^#/ or line == ""

      # IuWFNgp[X
      data = parser.create_object(line)

      # ǉ
      unless data.nil?
        case results
        when Hash
          results[data.datakey()] = data
        else
          results.push data
        end
      end
    end
  end

end
