# ReiACe{NX
# Authors:: fukuyama
# Date:: 2011/12/22
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

class Item_Container_Base
  def initialize
    @items = []
    @stack_counter = {}
    @stack_types = []
    @stack_items = []
  end

  def add_stack_type(type)
    @stack_types.push type
  end

  def stack_container?
    return (not @stack_types.empty?)
  end

  def stack_item?(item)
    @stack_types.include?(item.class)
  end

  # ACeǉ
  def add_item(item)
    return if item.nil?
    @items.push item
    if not @stack_counter.include?(item.class)
      @stack_counter[item.class] = Hash.new(0)
    end
    @stack_counter[item.class][item.id] += 1
    if stack_container?
      if (not @stack_types.include?(item.class)) or @stack_counter[item.class][item.id] == 1
        @stack_items.push item
      end
    end
  end

  # ǉł邩mF
  def addit?(parent_item, item)
    return true
  end

  # ACe폜
  def remove_item(item)
    return false unless @items.include?(item)
    @items.delete(item)
    if not @stack_counter.include?(item.class)
      @stack_counter[item.class] = Hash.new(0)
    end
    @stack_counter[item.class][item.id] -= 1
    if @stack_counter[item.class][item.id] < 0
      @stack_counter[item.class][item.id] = 0
    end
    if stack_container?
      if @stack_types.include?(item.class)
        # X^bNACecĂꍇ
        if @stack_counter[item.class][item.id] > 0
          i = @stack_items.index(item)
          # ƂĂACeX^bNACeɑ݂ꍇ́Aւ
          if not i.nil?
            @items.each do |item1|
              if item.class == item1.class and item.id == item1.id
                @stack_items[i] = item1
                break
              end
            end
          end
        end
      else
        # X^bNACeł͖́A폜
        @stack_items.delete(item)
      end
      if @stack_counter[item.class][item.id] == 0
        @stack_counter[item.class].delete(item.id)
        @stack_items.delete(item)
      end
    end
    return true
  end

  # 邩mF
  def removeit?(parent_item, item)
    return @items.include?(item)
  end

  # ACe̓ւ
  # item1 ̈ʒu  item2 
  def swap_item(item1,item2)
    return false if item1.nil? or item2.nil?
    if @items.include?(item1)
      i1 = @items.index(item1)
      if @items.include?(item2)
        # Ăꍇ
        i2 = @items.index(item2)
        @items[i1] = item2
        @items[i2] = item1
      else
        # item1 ̂ݎĂꍇ
        @items[i1] = item2
      end
      return true
    end
    return false
  end

  # ACe̊mF
  def include?(item)
    return @items.include?(item)
  end

  # ACeꗗ
  def each_item
    @items.each(&proc)
  end

  # X^bNACeꗗ
  def each_stack_item
    @stack_items.each(&proc)
  end

  # ACẽ\[g
  def sort!
    @items.sort!(&proc)
    @stack_items.sort!(&proc)
  end

  # ACe̐
  def item_count
    return @items.size
  end

  # ACe̐
  def item_count_by_id(type,id)
    if not @stack_counter.include?(type)
      @stack_counter[type] = Hash.new(0)
    end
    return @stack_counter[type][id]
  end
end
