# Xe[^XS
# Authors:: fukuyama
# Date:: 2012/02/25
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Status_All < ::Window_Selectable
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent)
      x = 32
      y = 16
      w = Graphics.width - 64
      h = Graphics.height - 32
      super(parent,x,y,w,h)
      @item_width = self.contents.width / 4 - (spacing / 2 * 3 / 4)
      @item_height = line_height
      set_handler(:ok, method(:close))
      set_handler(:cancel, method(:close))
      unselect
      refresh
    end

    def draw_text(x,y,text,align)
      self.contents.draw_text(x, y, @item_width, @item_height, text, align)
      return x, y + @item_height
    end

    def draw_line(x,y)
      y -= 3
      self.contents.fill_rect(x,y,@item_width,3,Color.new(0,0,0,128))
      self.contents.fill_rect(x+1,y+1,@item_width-2,1,normal_color)
      return x, y
    end

    # tbV
    def refresh_actor(x,y,actor)
      w = @item_width
      h = @item_height
      c = self.contents
      # O
      change_color(normal_color)
      (x,y) = draw_text(x,y, actor.name, 0)
      # go
      change_color(system_color)
      (x,t) = draw_text(x,y, Vocab.hp_a, 0)
      change_color(normal_color)
      (x,y) = draw_text(x,y, actor.hp.to_s, 2)
      (x,y) = draw_line(x,y)
      (x,y) = draw_text(x,y, actor.mhp.to_s, 2)
      # lo
      change_color(system_color)
      (x,t) = draw_text(x,y, Vocab.mp_a, 0)
      change_color(normal_color)
      (x,y) = draw_text(x,y, actor.mp.to_s, 2)
      (x,y) = draw_line(x,y)
      (x,y) = draw_text(x,y, actor.mmp.to_s, 2)
      # p[^
      for i in 2 .. 5
        change_color(system_color)
        (x,y) = draw_text(x,y, Vocab.param(i),0)
        change_color(normal_color)
        (x,y) = draw_text(x,y, actor.param(i),2)
      end
      # ku
      change_color(system_color)
      (x,y) = draw_text(x,y, 'x',0)
      change_color(normal_color)
      (x,y) = draw_text(x,y, actor.level.to_s,2)
    end

    def refresh
      self.contents.clear if self.contents.nil?
      (x,y) = 0,0
      for actor in $game_party.members
        refresh_actor(x,y,actor)
        x += @item_width + (spacing / 2)
      end
    end

  end

end
