# 悳AN^[j[
# Authors:: fukuyama
# Date:: 2012/01/27
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Actor_Menu_Status < ::DQ::Window_Actor_Menu_Base
    include Window_Command_Title_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuActorStatusTitle
      # EBhEʒu
      rect = parent.item_rect_for_text(parent.index)
      super(parent,parent.left + rect.x - 4,parent.top + rect.y)

      # AN^[̃Xe[^XEBhE
      @actor_status_windows = []
      # S̃Xe[^XEBhE
      @all_status_windows = []

      # AN^[ȈՃXe[^X
      @window_actor_summary = Window_Status_Summary.new(self)
      @actor_status_windows.push(@window_actor_summary)

      # AN^[ڍ׃Xe[^X
      @window_actor_status_detail = Window_Status_Detail.new(self)
      @actor_status_windows.push(@window_actor_status_detail)

      # AN^[
      @window_actor_equip_item = Window_Status_Equip.new(self)
      @actor_status_windows.push(@window_actor_equip_item)

      # vCԃEBhE
      add_all_status_windows(Window_Status_PlayTime.new(self))

      # S[hEBhE
      add_all_status_windows(Window_Status_Gold.new(self))

      if Module.constants.include?('WINDOW_STATUS_VARIABLES')
        for v in WINDOW_STATUS_VARIABLES
          window = add_all_status_windows(Window_Markup_Text.new(0,0,ALL_STATUS_WIDTH + 32,Markup_New_Line.line_height + 32))
          window.set_text(v)
        end
      end

      self.actor_status_visible = true
      self.refresh_actor
    end

    # R}hXg̍쐬
    def make_command_list
      super
      # j[ǉ
      add_command(Vocab::MenuActorStatusAll, :all_status)
    end

    def add_all_status_windows(window)
      window.left = self.right
      if @all_status_windows.empty?
        window.top = top_window.top
      else
        window.top = @all_status_windows.last.bottom
      end
      @all_status_windows.push(window)
      return window
    end

    def all_status
      window = Window_Status_All.new(self)
      self.active_window = window.class
    end

    def select_actor
      if self.actor.class.learnings.size != 0
        # XLXe[^XEBhEANeBu
        window = Window_Status_Skill.new(self)
        self.active_window = window.class
      else
        # XLꍇ̓ANeBuɖ߂
        self.activate()
      end
    end

    def change_index
      refresh_actor
    end

    def refresh_actor
      if self.actor.nil?
        self.all_status_visible = true
      else
        self.actor_status_visible = true
        @actor_status_windows.each do |window|
          window.actor = self.actor
        end
      end
    end

    def actor_status_visible=(visible)
      @actor_status_windows.each do |window|
        window.visible = visible
        window.z = self.z
      end
      @all_status_windows.each do |window|
        window.visible = (not visible)
        window.z = self.z
      end
    end

    def all_status_visible=(visible)
      self.actor_status_visible = (not visible)
    end
  end

end
