# ACep`ohiItem_Facadej
# ֘ÃObZ[W
# Authors:: fukuyama
# Date:: 2012/01/12
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module Item_Facade
  module_function
  # s\ACe̎擾
  def get_use_item(item)
    # gp\W[CN[hĂꍇ
    if item.is_a?(Item_Use_Module)
      return item.use_item
    end
    return item
  end

  # ĩ\[g
  def equip_sort(actor)
    equips = actor.equips
    items = actor.all_items - equips
    list = []
    equips.each() do |item|
      if actor.backpack.remove_item(item)
        list.push(item)
      end
    end
    items.each() do |item|
      if actor.backpack.remove_item(item)
        list.push(item)
      end
    end
    list.each() do |item|
      actor.backpack.add_item(item)
    end
  end

  # 
  def equip_item(actor,item)
    # ӏ̊mF
    slot_id = actor.empty_slot(item.etype_id)
    # 
    actor.change_equip(slot_id,item)
    equip_sort(actor)
  end

  # ĂꍇO
  def remove_equip_item(owner,item)
    if owner.is_a?(Game_Actor) and owner.equips.include?(item)
      i = owner.equips.index(item)
      owner.change_equip(i,nil)
      equip_sort(owner)
    end
  end

  # ACeg[h
  def trade_item(owner1,item1,owner2,item2=nil)
    # ĂꍇO
    remove_equip_item(owner1,item1)
    if item2.nil?
      # n
      owner1.backpack.remove_item(item1)
      owner2.backpack.add_item(item1)
    elsif item1 != item2
      # ĂꍇO
      remove_equip_item(owner2,item2)
      # 
      if owner1 == owner2
        # 傪
        owner1.backpack.swap_item(item1,item2)
      else
        # 傪Ⴄ
        owner1.backpack.swap_item(item1,item2)
        owner2.backpack.swap_item(item2,item1)
      end
    end
  end

  # Œ肳Ă邩H
  # item:: ӏ擾ACe
  def equip_fix?(owner,item)
    return false if item.nil? or owner.nil?
    # ownerAN^[Ȃ
    return false if not owner.is_a?(Game_Actor)
    # ACeȂ
    return false if item.is_a?(Game_Item)
    # ӏ̊mF
    slot_id = owner.empty_slot(item.etype_id)
    # ӏŒ肳Ăꍇ
    return (not owner.equip_change_ok?(slot_id))
  end

  # ACêĂ邩ǂmF
  def throw_item?(owner,item)
    # 傪܂Ăꍇ́A{ɏĂ邩mFBӂ̏ꍇH
    if not owner.nil? and not owner.backpack.include?(item)
      return false
    end

    # XXX: iÓ̕uȂ́vibΏj
    if item.price == 0
      return false
    end
    return true
  end

  # ACeĂ
  def throw_item(owner,item)
    # Ă邩H
    if throw_item?(owner,item)
      # ĂꍇO
      remove_equip_item(owner,item)
      return owner.backpack.remove_item(item)
    end
    return false
  end

  # ACeH
  def item?(item)
    return (item.is_a?(RPG::Item) or item.is_a?(Game_Item))
  end

  # 킩H
  def weapon?(item)
    return (item.is_a?(RPG::Weapon) or item.is_a?(Game_Weapon))
  end

  # hH
  def armor?(item)
    return (item.is_a?(RPG::Armor) or item.is_a?(Game_Armor))
  end

end
