# ^[QbgEBhEW[
# Authors:: fukuyama
# Date:: 2012/03/26
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    module Window_Target_Module
      def initialize(*args)
        super(*args)
        @target_actor_opening = false
        @target_enemy_opening = false
        @last_select = false
      end

      def update
        update_target_actor
        update_target_enemy
        super
      end

      def update_target_actor
        if @target_actor_opening and (@window_battle_enemy.nil? or @window_battle_enemy.disposed? or @window_battle_enemy.close?)
          @window_battle_actor = Window_Battle_Actor.new(self,@actor)
          @target_actor_opening = false
          @window_battle_enemy = nil
          self.active_window = @window_battle_actor.class
        end
      end

      def update_target_enemy
        if @target_enemy_opening and (@window_battle_actor.nil? or @window_battle_actor.disposed? or @window_battle_actor.close?)
          @window_battle_enemy = Window_Battle_Enemy.new(self,@actor)
          if @last_select
            @window_battle_enemy.arrow_index = $game_troop.alive_members.size - 1
          end
          @target_enemy_opening = false
          @window_battle_actor = nil
          self.active_window = @window_battle_enemy.class
        end
      end

      def target_actor(last_select = false)
        @target_actor_opening = true
        @last_select = last_select
        update_target_actor
      end

      def target_enemy(last_select = false)
        @target_enemy_opening = true
        @last_select = last_select
        update_target_enemy
      end

      def next_window(item)
        if item.need_selection?
          # I𑀍삪Kv
          if item.for_opponent?
            # GI
            target_enemy
          elsif item.for_friend?
            # I
            target_actor
          end
        else
          # I𑀍삪KvȂ
          top_window.close
          SceneManager.scene.next_command
        end
      end
    end

  end
end
