# XLEBhE
# Authors:: fukuyama
# Date:: 2012/03/16
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Window_Skill < ::DQ::Battle::Window_Battle_Command
      include Window_Tree_Module
      include Window_Target_Module
      # 
      def initialize(parent,actor)
        @actor = actor
        super(parent,parent.left,parent.top)
      end

      # wvEBhE쐬
      def create_help_window
        hw = Window_Help.new(visible_line_number)
        hw.top = self.top
        hw.left = self.right
        hw.create_contents()
        hw.hide
        add_child(hw)
        self.help_window = hw
      end

      # R}hXg̍쐬
      # AN^[XL̍XV
      def make_command_list
        if not @actor.nil?
          skills = @actor.skills.select() {|s|s.battle_ok?}
          skills.each do |skill|
            add_command(skill.name, :select_skill, true, skill)
          end
        end
      end

      # XL
      def skill
        return self.current_ext
      end

      # EBhE̕
      def window_width
        CHARA_WIDTH * 22
      end

      # j[̕\s
      def visible_line_number
        5
      end

      # ̎擾
      def col_max
        2
      end

      # XLI
      def select_skill
        if not @actor.usable?(skill)
          activate
          return
        end
        @actor.input.set_skill(skill.id)
        @actor.last_skill.object = skill
        next_window(skill)
      end

      # wvXV
      def update_help
        if not self.help_window.nil?
          if not self.skill.nil?
            text = self.skill.description.dup
            text << "\\bottom"
            text << "\\center_left[#{skill.mp_cost}/]#{skill.mp_cost}/"
            text << "\\right[#{@actor.mp}]#{@actor.mp}"
            self.help_window.set_text text
          else
            self.help_window.set_text ""
          end
        end
      end

    end
  end
end
