# ACeEBhE
# Authors:: fukuyama
# Date:: 2012/03/16
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Window_Item < ::DQ::Battle::Window_Battle_Command
      include Window_Tree_Module
      include Window_Target_Module
      # 
      def initialize(parent,actor)
        @actor = actor
        super(parent,parent.left,parent.top)
      end

      # wvEBhE쐬
      def create_help_window
        # ACewvEBhE쐬
        hw = Window_Help.new(visible_line_number)
        hw.top = self.top
        hw.left = self.right
        hw.create_contents()
        hw.hide
        add_child(hw)
        self.help_window = hw
      end

      # R}hXg̍쐬
      def make_command_list
        if not @actor.nil?
          equips = @actor.equips
          items = @actor.all_items - equips
          equips.each do |item|
            add_command('E ' + item.name, :select_item, true, item) unless item.nil?
          end
          items.each do |item|
            add_command(item.name, :select_item, true, item)
          end
        end
      end

      # ACe
      def item
        return self.current_ext
      end

      # EBhE̕
      def window_width
        CHARA_WIDTH * 22
      end

      # j[̕\s
      def visible_line_number
        5
      end

      # ̎擾
      def col_max
        2
      end

      # ACȇI
      def select_item
        if item.is_a? Game_Item
          if not @actor.usable?(item)
            # gpłȂACe
            top_window.close
            SceneManager.scene.next_command
            return
          end
          @actor.input.set_item_object(item)
          # TODO:Ƃƃp[eBACeȂ̂ŁAJ[\AN^[oĂ킯ł͂ȂB
          # @actor.last_item.object = item
          next_window(item)
        else
          window = Window_Item_Menu.new(self,@actor,item)
          self.active_window = window.class
        end
      end

      # wvXV
      def update_help
        if (not @window_help.nil?) and (not @window_help.disposed?)
          if not self.item.nil?
            @window_help.set_text self.item.description
          else
            @window_help.set_text ""
          end
        end
      end
    end

  end
end
