# cppGl~[A[ Sprite_Enemy_Arrow
# Authors:: fukuyama
# Date:: 2012/03/14
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Sprite_Enemy_Arrow < ::Sprite
      # 
      def initialize(viewport=nil)
        super(viewport)
        self.visible = false
        @bitmap_top = Cache.script_bitmap('enemy_arrow')
        @bitmap_bottom = Bitmap.new(@bitmap_top.width,@bitmap_top.height)
        @bitmap_bottom.mirror_vertical(@bitmap_top)
        self.bitmap = @bitmap_top
        self.ox = self.bitmap.width / 2
        self.oy = self.bitmap.height / 2
      end

      # Gl~[ݒ
      def enemy=(enemy)
        return if enemy.nil?
        self.visible = true
        # XvCg̍Wݒ
        battler_image = Cache.battler(enemy.battler_name,enemy.battler_hue)
        self.x = enemy.screen_x
        if Graphics.height / 2 < enemy.screen_y
          # Gl~[̏
          self.y = enemy.screen_y - battler_image.height
          self.bitmap = @bitmap_top
        else
          # Gl~[̉
          self.y = enemy.screen_y
          self.bitmap = @bitmap_bottom
        end
      end
    end
  end
end

