# ogʂ̏sNXłB
# Authors:: fukuyama
# Date:: 2012/03/03
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

class Scene_Battle
  # OEBhE̍쐬
  def create_log_window
    @log_window = ::DQ::Battle::Window_Battle_Log.new
    @log_window.method_wait = method(:wait)
    @log_window.method_wait_for_effect = method(:wait_for_effect)
    @log_window.y = Graphics.height - @log_window.height
  end

  # \r[|[g̍쐬
  def create_info_viewport
    @info_viewport = Viewport.new
    @info_viewport.z = 100
    @status_window.viewport = @info_viewport
  end

  # GLEBhE̍쐬
  def create_enemy_window
    #    @enemy_window = ::DQ::Battle::Window_Battle_Enemy.new(@info_viewport)
    #    @enemy_window.x = 128
    #    @enemy_window.y = Graphics.height - @enemy_window.height
    #    @enemy_window.set_handler(:ok,     method(:on_enemy_ok))
    #    @enemy_window.set_handler(:cancel, method(:on_enemy_cancel))
  end

  # Xe[^XEBhE̍쐬
  def create_status_window
    @status_window = Window_BattleStatus.new
  end

  # p[eBR}hEBhE̍쐬
  def create_party_command_window
    @party_command_window = ::DQ::Battle::Window_Party_Command.new
    @party_command_window.viewport = @info_viewport
    @party_command_window.y = Graphics.height - @party_command_window.height
  end

  # AN^[R}hEBhE̍쐬
  def create_actor_command_window
    @actor_command_window = ::DQ::Battle::Window_Actor_Command.new
    @actor_command_window.viewport = @info_viewport
    @actor_command_window.y = Graphics.height - @actor_command_window.height
  end

  # \r[|[g̍XV
  def update_info_viewport
  end

  # ^[Jn
  def turn_start
    @party_command_window.close
    @actor_command_window.close
    @status_window.unselect
    @subject =  nil
    BattleManager.turn_start
    @log_window.open
    @log_window.wait
    @log_window.clear
  end

  # ^[I
  def turn_end
    all_battle_members.each do |battler|
      battler.on_turn_end
      refresh_status
      @log_window.display_auto_affected_status(battler)
      @log_window.wait_and_clear
    end
    @log_window.close
    BattleManager.turn_end
    process_event
    start_party_command_selection
  end

  def battle_end?
    return ($game_party.members.empty? or $game_party.all_dead? or $game_troop.all_dead? or BattleManager.aborting?)
  end

  def missing_action
    item = @subject.current_action.item
    @log_window.display_cannot_used_item(@subject, item)
    @log_window.wait_and_clear
  end

  # 퓬s̏
  def process_action
    return if scene_changing?
    if !@subject || !@subject.current_action
      @subject = BattleManager.next_subject
    end
    return turn_end unless @subject
    if @subject.current_action
      @subject.current_action.prepare
      if @subject.current_action.valid?
        @status_window.open
        execute_action
      else
        missing_action
      end
      @subject.remove_current_action
    end
    process_action_end unless @subject.current_action
  end

  # 퓬sȈ
  def process_action_end
    @subject.on_action_end
    refresh_status
    @log_window.display_auto_affected_status(@subject)
    @log_window.wait_and_clear
    @log_window.display_current_state(@subject)
    @log_window.wait_and_clear
    @log_window.close if battle_end?
    BattleManager.judge_win_loss
  end

  # 퓬s̎s
  def execute_action
    @subject.sprite_effect_type = :whiten
    if @subject.current_action.equip
      equip_item
    else
      use_item
    end
    @log_window.wait_and_clear
  end

  # ACȇ
  def equip_item
    item = @subject.current_action.item
    if @subject.equips.include?(item)
      @log_window.display_remove_equip_item(@subject, item)
      Item_Facade.remove_equip_item(@subject,item)
    else
      @log_window.display_equip_item(@subject, item)
      Item_Facade.equip_item(@subject,item)
    end
    refresh_status
    Sound.play_equip
    @log_window.wait_and_clear
  end
  
  # GLmn
  def on_enemy_ok
    next_command
  end
end
