# Q[}bṽm[hNXi`ASY̎j
# Author:: fukuyama
# Date:: 2012/03/11
# Copyright:: Copyright (c) 2012 rgss-lib

class Node_Game_Map < AStarAlgorithm::Node
  attr_reader :x
  attr_reader :y
  
  # 
  def initialize(x=0,y=0,event_id=0,nodes={})
    super()
    @x = x
    @y = y
    @event_id = event_id
    @nodes = nodes
    set_node(@x,@y,self)
  end
  
  # m[h̐ݒ
  def set_node(x,y,node)
    unless @nodes.include? x
      @nodes[x] = {}
    end
    unless @nodes[x].include? y
      if node.nil?
        @nodes[x][y] = Node_Game_Map.new(x,y,@event_id,@nodes)
      else
        @nodes[x][y] = node
      end
    end
  end
  
  # m[h̎擾
  def get_node(x,y)
    set_node(x,y,nil) # ꍇ͍쐬
    return @nodes[x][y]
  end
  
  # Cxg̎擾
  def event
    $game_map.interpreter.get_character(@event_id)
  end
  
  # ߂
  def direction(node)
    return 0 unless adjacent?(node) # אڂĖ
    return 2 if @y < node.y
    return 4 if @x > node.x
    return 6 if @x < node.x
    return 8 if @y > node.y
    return 0
  end
  
  # אڂĂ邩H
  def adjacent?(node)
    # ʒȕꍇƁA΂߈ʒȕꍇאڂĂȂƂ݂Ȃ
    if (node.x == @x and node.y == @y) or (node.x != @x and node.y != @y)
      return false
    end
    return ((@x - 1 .. @x + 1).include?(node.x) or (@y - 1 .. @y + 1).include?(node.y))
  end
  
  # selfnode܂ł̋ij
  def distance(node)
    return (@x - node.x).abs + (@y - node.y).abs
  end
  
  # ړ\H
  def passable?(node)
    unless adjacent?(node)
      # אڂĂȂ
      return false
    end
    # ߂
    d = self.direction(node)
    if d == 0
      return false
    end
    # ړ\
    return self.event.passable?(@x,@y,d)
  end
  
  # אڃm[h̎擾
  def adjacency_nodes
    return [
    get_node(@x+1,@y),
    get_node(@x-1,@y),
    get_node(@x,@y+1),
    get_node(@x,@y-1),
    ]
  end
  
end

module Event_Script
  module_function
  # ꏊړ`
  def move_to_astar(event_id,x,y,param={})
    # Cxg擾
    event = $game_map.interpreter.get_character(event_id)
    if event.nil?
      return true
    end
    # m[hǗp
    m = {}
    # X^[gm[h
    start_node = Node_Game_Map.new(event.x,event.y,event_id,m)
    # S[m[h
    gool_node  = Node_Game_Map.new(x,y,event_id,m)
    # `ASYŌoHT
    nodes = AStarAlgorithm.search(start_node,gool_node)
    return true if nodes.empty?
    
    # ړ[g쐬
    move_route = RPG::MoveRoute.new
    move_route.repeat = false # JԂȂ
    move_route.skippable = true # ړłȂ疳
    
    # ړ[g̃R}h쐬
    move_route.list = []
    # 蔲ݒ
    if param['ړ蔲']
      move_route.list.push RPG::MoveCommand.new(37)
    end
    codes = {2=>1,4=>2,6=>3,8=>4}
    for i in 1 ... nodes.size
      # 2:  4:  6:E  8: # 
      d = nodes[i-1].direction(nodes[i])
      # 1:  2:  3:E  4: # ړR}hݒ
      move_route.list.push RPG::MoveCommand.new(codes[d])
    end
    if param['ړ蔲']
      move_route.list.push RPG::MoveCommand.new(38)
    end
    if param.include?('')
      case param['']
      when 2 # 
        move_route.list.push RPG::MoveCommand.new(16)
      when 4 # 
        move_route.list.push RPG::MoveCommand.new(17)
      when 6 # E
        move_route.list.push RPG::MoveCommand.new(18)
      when 8  # 
        move_route.list.push RPG::MoveCommand.new(19)
      end
    end
    # Ō͋̂Ă(Ip)
    move_route.list.push RPG::MoveCommand.new
    
    # ړ[g̋
    event.force_move_route(move_route)
    return true
  end
end
