# tH[NX
# Authors:: fukuyama
# Date:: 2012/02/13
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

# tH[NXW[
module Game_Follower_Module
  # ǐՈʒu
  class Chase_Data
    def initialize(x,y)
      @x = x
      @y = y
    end
    attr_reader :x
    attr_reader :y

    def jump?
      self.is_a?(Jump_Data)
    end
  end

  class Jump_Data < Chase_Data
    def initialize(x,y)
      super(x,y)
    end
  end

  attr_reader :preceding_character

  # 
  def initialize
    super
    @chase_jump_data = []
  end

  # ǐՃWv[h
  def chase_jump(x_plus, y_plus)
    # ǐՃWv[hJn̈ʒuƃWvp[^ۑ
    pc = @preceding_character
    if chase_jumping? or jumping?
      @chase_jump_data.push(Jump_Data.new(x_plus,y_plus))
    else
      @chase_jump_data.push(Chase_Data.new(pc.x,pc.y))
      while not pc.is_a?(Game_Player)
        pc = pc.preceding_character
        @chase_jump_data.push(Chase_Data.new(pc.x,pc.y))
      end
      @chase_jump_data.push(Jump_Data.new(x_plus,y_plus))
    end
  end

  # ǐՃWv[hH
  def chase_jumping?
    not @chase_jump_data.empty?
  end

  # 擱L̒ǐ
  def chase_preceding_character_xy(px,py)
    sx = distance_x_from(px)
    sy = distance_y_from(py)
    if sx != 0 && sy != 0
      move_diagonal(sx > 0 ? 4 : 6, sy > 0 ? 8 : 2)
    elsif sx != 0
      move_straight(sx > 0 ? 4 : 6)
    elsif sy != 0
      move_straight(sy > 0 ? 8 : 2)
    end
  end

  # 擱L̒ǐՁiړj
  def chase_preceding_character_move
    chase_preceding_character_xy(@preceding_character.x,@preceding_character.y)
  end

  # 擱L̒ǐՁiWvj
  def chase_preceding_character_jump
    data = @chase_jump_data.shift
    if data.jump?
      # WvʒuɓBꍇAWv
      jump(data.x,data.y)
    else
      # 擱Lꏊǐ
      chase_preceding_character_xy(data.x,data.y)
    end
  end
end

# tH[NX̉
class Game_Follower < Game_Character
  # @\p̃W[
  include Game_Follower_Module
  # 擱L̒ǐ
  def chase_preceding_character
    unless moving?
      if chase_jumping?
        chase_preceding_character_jump
      else
        chase_preceding_character_move
      end
    end
  end

  # 擱LN^[Ɠʒuɂ邩𔻒
  def gather?
    !jumping? && !moving? && pos?(@preceding_character.x, @preceding_character.y)
  end
end
