# Q[XCb`W[
# Authors:: fukuyama
# Date:: 2011/12/21
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

# $game_switches ̃bp[
# OŃANZXł悤ɂ
module Switches
  # tp̃}bv
  @switches_id_map = nil
  # XCb`񏀔
  def self.init
    if @switches_id_map.nil?
      @switches_id_map = Hash.new(-1.freeze)
      $data_system.switches.each_with_index do |key,index|
        unless key.nil? or key.empty?
          @switches_id_map[key] = index
        end
      end
    end
  end
  System_Event.add_init_handler(self)

  # key ̃XCb`擾
  # ݃`FbNɂ́Ainclude? g
  def self.[]( key, default = false )
    id = index(key)
    if id < 0
      return default
    end
    return $game_switches[id]
  end

  # key ̃XCb`valɂ
  def self.[]=( key, val )
    id = index(key)
    if id < 0
      return nil
    end
    return $game_switches[id] = val
  end

  # key XCb`݊mF
  def self.include?(key)
    if key.is_a?(Integer)
      return (0 < key and key < $data_system.switches.size)
    end
    return @switches_id_map.include?(key)
  end

  # key XCb`CfbNX擾
  def self.index(key)
    if key.is_a?(Integer) and 0 < key and key < $data_system.switches.size
      return key
    end
    return @switches_id_map[key]
  end
end
