class Window_TitleCommand
  def make_command_list
    add_command(Vocab::new_game, :new_game)
    add_command(Vocab::continue, :continue, continue_enabled)
    add_command(Vocab::shutdown, :shutdown)
    add_command('TEST', :test)
  end
end

class Scene_Title
  def create_command_window
    @command_window = Window_TitleCommand.new
    @command_window.set_handler(:new_game, method(:command_new_game))
    @command_window.set_handler(:continue, method(:command_continue))
    @command_window.set_handler(:shutdown, method(:command_shutdown))
    @command_window.set_handler(:test, method(:command_test))
  end

  def command_test
    @command_test = Window_Test.new(0,0)
  end
end

class Window_Test < ::DQ::Window_Command_Base
  def make_command_list
    19.times() do |i|
      add_command('Test%02d'%i, :test)
    end
  end

  def visible_line_number
    3
  end

  def col_max
    2
  end
  
  def test
  end
end
