# -*- encoding: sjis -*-

SRC_DIR = 'src/' unless defined? SRC_DIR
OUTPUT_DIR = 'output/' unless defined? OUTPUT_DIR

SCRIPT_BASE_FILE = 'data/Scripts.rvdata2' unless defined? SCRIPT_BASE_FILE

SCRIPT_FILES = []
if defined? SCRIPT_LIST
  SCRIPT_FILES.push(*SCRIPT_LIST.find_all(){|o|o=~/^[^#]/}.collect(){|o|SRC_DIR+o})
end

SCRIPT_TARGET = OUTPUT_DIR + File.basename(SCRIPT_BASE_FILE)

require 'rake/clean'

CLOBBER.include(SCRIPT_TARGET)

# default task
task :default => :all

task :all => [:scripts]

task :scripts => [SCRIPT_TARGET]

task :doc => SCRIPT_FILES do
  require 'rdoc/rdoc'
  r = RDoc::RDoc.new
  r.document %W(-x rakefile --charset sjis -o #{OUTPUT_DIR}).push(*SCRIPT_FILES)
end

# remake task
desc 'Remake (clobber and all)'
task :remake => [:clobber,:all]

# rules
rule(SCRIPT_TARGET => SCRIPT_FILES) do |t|
  puts 'make ' + t.name
  makeScript(t.name,SCRIPT_FILES,{:script_base_file=>SCRIPT_BASE_FILE})
end

# functions
require 'zlib'
require 'Win32API'

def createSectionData(name,data)
  return [
    name.object_id,
    name.encode('utf-8'),
    Zlib::Deflate.deflate(data.encode('utf-8'))
  ]
end

def loadFileData(filename)
  data = ''
  open(filename).each do |line|
    line.sub!(/[ \t\n]*$/,"\r\n")
    data += line
  end
  return data
end

def makeScript(target,files,config={
    :script_base_file=>'data/Scripts.rxdata'
  })
  script_base_used = false

  if (not config[:script_base_file].nil?) and FileTest.exist?(config[:script_base_file])
    script_base_used = true
    case File.basename(config[:script_base_file])
    when 'Scripts.rxdata'
      type = :xp
    when 'Scripts.rvdata'
      type = :vx
    when 'Scripts.rvdata2'
      type = :vxace
    else
      type = :xp
    end
  end

  scripts = []
  material_index = 0

  if script_base_used
    File.open(config[:script_base_file], "rb") do |f|
      scripts = Marshal.load(f)
    end
    case type
    when :xp
      material_index = scripts.size - 1
    when :vx
      material_index = scripts.collect() {|s|s[1].encode('sjis')}.index('( ɒǉ )')
    when :vxace
      material_index = scripts.collect() {|s|s[1].encode('sjis')}.index('( ɒǉ )')
    end
  end

  files.each() do |filename|
    name = File.basename(filename)
    data = loadFileData(filename)
    section = createSectionData(name,data)
    scripts.insert(material_index,section)
    material_index += 1
  end

  File.open(target, "wb") do |f|
    Marshal.dump(scripts, f)
  end
  if $DEBUG
    puts '--'
    File.open(SCRIPT_TARGET, "rb") do |f|
      Marshal.load(f).each() do |s|
        puts s[1].encode('sjis')
      end
    end
    puts '--'
  end
end
