# ReiACeW[
# Authors:: fukuyama
# Date:: 2011/12/22
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Container_Item_Module
  # Rei
  def container=(container)
    @container = container
  end

  # ReiH
  def container?
    return (not @container.nil?)
  end

  # ACeǉ
  def addit?(item)
    return @container.addit?(self, item)
  end

  # ACeǉ
  def add_item(item)
    if addit?(item)
      @container.add_item(item)
      return true
    end
    return false
  end

  # ACe폜
  def removeit?(item)
    return @container.removeit?(self, item)
  end

  # ACe폜
  def remove_item(item)
    if removeit?(item)
      @container.remove_item(item)
      return true
    end
    return false
  end

  # ACe̓ւ
  # item1 ̈ʒu  item2 
  def swap_item(item1,item2)
    return @container.swap_item(item1,item2)
  end
  
  # ACe̊mF
  def include?(item)
    return @container.include?(item)
  end

  # ACẽ\[g
  def sort!
    @container.sort!(&proc)
  end

  #  # ACeꗗ
  #  def each_item
  #    @container.each_item(&proc)
  #  end
  #
  #  # X^bNACeꗗ
  #  def each_stack_item
  #    @container.each_stack_item(&proc)
  #  end

  def find_item(type,id)
    @container.each_item() do |item|
      if item.is_a?(type) and item.id == id
        return item
      end
    end
  end

  def find_all_items(type=nil,id=0)
    items = []
    if type.nil? and id == 0
      @container.each_item() do |item|
        items.push(item)
      end
    elsif (not type.nil?) and id == 0
      @container.each_item() do |item|
        items.push(item) if item.is_a?(type)
      end
    elsif (not type.nil?) and id > 0
      @container.each_item() do |item|
        items.push(item) if item.is_a?(type) and item.id == id
      end
    end
    items
  end

  def stack_items
    items = []
    @container.each_stack_item() do |item|
      items.push(item)
    end
    items
  end

  def stack_item?(item)
    @container.stack_item?(item)
  end

  # ACe̐
  def item_count
    return @container.item_count
  end

  # ACe̐
  def item_count_by_id(type,id)
    return @container.item_count_by_id(type,id)
  end

  # ACe̐
  def item_number(item)
    return @container.item_count_by_id(item.class,item.id)
  end

end
