# 퓬pACej[EBhE
# Authors:: fukuyama
# Date:: 2012/03/16
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Window_Item_Menu < ::DQ::Battle::Window_Battle_Command
      include Window_Tree_Module
      include Window_Target_Module
      # 
      def initialize(parent,actor,item)
        @actor = actor
        @item = item
        super(parent,parent.right,parent.top)
      end

      # R}hXg
      def make_command_list
        add_command(Vocab::Battle::MenuItemUse,:use_item)
        if @actor.is_a? Game_Actor
          if @actor.equips.include?(@item)
            add_command(Vocab::Battle::MenuItemRemoveEquip,:equip_item)
          else
            add_command(Vocab::Battle::MenuItemEquip,:equip_item)
          end
        end
      end

      def use_item
        item = Item_Facade.get_use_item(@item)
        item = @item if item.nil?
        @actor.input.set_item_object(item)
        if not @actor.usable?(item)
          # gpłȂACe
          top_window.close
          SceneManager.scene.next_command
          return
        end
        next_window(item)
      end

      def equip_item
        # Œ肳Ăꍇ
        if Item_Facade.equip_fix?(@item,@actor)
          event = Script_Event.new
          event.message("#{@actor.name}́@#{@item.name}@łȂB") # XXX EFCgc
          event.brank
          # CxgZbgAbv
          $game_system.battle_interpreter.setup(event.event_commands, 0)
          return
        end
        # \
        if not @actor.equippable?(@item)
          event = Script_Event.new
          event.message("#{@actor.name}́@#{@item.name}@łȂB") # XXX EFCgc
          event.brank
          # CxgZbgAbv
          $game_system.battle_interpreter.setup(event.event_commands, 0)
          return
        end
        @actor.input.set_equip_item_object(@item)
        top_window.close
        SceneManager.scene.next_command
      end
    end

  end
end
