# Gl~[IEBhE
# Authors:: fukuyama
# Date:: 2012/03/08
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  module Battle
    class Window_Battle_Enemy < ::DQ::Battle::Window_Battle_Command
      include Window_Tree_Module
      # 
      def initialize(parent,actor)
        @parent = parent
        @actor = actor
        @arrow_index = 0
        @arrow = Sprite_Enemy_Arrow.new(parent.viewport)
        window = find_window(Window_Actor_Command)
        super(parent,window.right,window.top)
      end

      # Gl~[
      def enemy
        @enemies[@arrow_index]
      end
      
      # A[̃CfbNXݒ
      def arrow_index=(index)
        @arrow_index = index
        refresh_arrow
      end

      # EBhE̎擾
      def window_width
        Graphics.width - 128
      end

      # 
      def close
        @arrow.visible = false
        super
      end

      # j
      def dispose
        @arrow.dispose
        super
      end

      # ĕ`
      def refresh
        super
        refresh_arrow
      end

      # A[J[\̍ĕ`
      def refresh_arrow
        @arrow.enemy = self.enemy
      end

      # R}hXg̍쐬
      def make_command_list
        # Gl~[
        @enemies_count = {}
        @enemies = []
        @enemies_arrow_index = {}

        # Gl~[O擾
        for enemy in $game_troop.alive_members.sort {|a,b| a.screen_x <=> b.screen_x}
          next if not enemy.exist?
          name = enemy.original_name
          unless @enemies_count.include?(name)
            @enemies_count[name] = 0
            @enemies_arrow_index[name] = @enemies.size
            add_command(name, :select_target_enemy, true, name)
          end
          @enemies_count[name] += 1
          @enemies.push(enemy)
        end
      end

      # ^[QbgGl~[I
      def select_target_enemy
        @actor.input.target_index = self.enemy.index
        @actor.input.target_side = :opponent
        top_window.close
        SceneManager.scene.on_enemy_ok
      end

      # ڂ̕`
      def draw_item(index)
        name = command_name(index)
        rect = item_rect_for_text(index)
        draw_text(rect, name)
        count = "#{@enemies_count[name]} C" # TODO: Pʂǂ悤H VXAceȂGl~[Ƃɂ邩
        draw_text(rect, count, 2)
      end

      # IΏۂύX
      def change_select_target(last_select=false)
        Sound.play_cursor
        parent.target_actor(last_select)
        close
      end

      # J[\EɈړ
      def cursor_right(wrap = false)
        if @arrow_index + 1 >= @enemies.size
          change_select_target
          return
        end
        @arrow_index = (@arrow_index + 1) % @enemies.size
        refresh_arrow
        select_ext(self.enemy.original_name)
        Sound.play_cursor
      end

      # J[\Ɉړ
      def cursor_left(wrap = false)
        if @arrow_index <= 0
          change_select_target
          return
        end
        @arrow_index = (@arrow_index - 1 + @enemies.size) % @enemies.size
        refresh_arrow
        select_ext(self.enemy.original_name)
        Sound.play_cursor
      end

      # CfbNXύX
      def change_index
        #        @arrow_index = @enemies_arrow_index[current_ext()]
        refresh_arrow
      end

    end
  end
end
