# EBhE^CgW[
# Authors:: fukuyama
# Date:: 2011/12/28
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

# EBhER}hɃ^Cgǉ
module Window_Command_Title_Module
  # ^Cg
  attr_accessor :title
  attr_accessor :title_align
  # ^Cgݒ
  def title=(title)
    @title = title
    bmp = Bitmap.new(Graphics.width,line_height())
    @title_rect = bmp.text_size(@title)
    @title_rect.width = (@title_rect.width + spacing + 12) * col_max - spacing
    bmp.dispose()
  end

  # ^Cg̕
  def title_width
    return 0 if @title.nil?
    return @title_rect.width
  end

  # ^Cg̍
  def title_height
    return 0 if @title.nil?
    return @title_rect.height
  end

  # EBhE̕
  def window_width
    [super,title_width + standard_padding * 2].max
  end

  # EBhE̍
  def window_height
    super + title_height
  end

  # ڂ`悷`̎擾
  def item_rect(index)
    rect = super(index)
    rect.y += title_height
    rect
  end

  # Sڂ̕`
  def draw_all_items
    draw_title
    super
  end

  # ^Cg̕`
  def draw_title
    if @title_align.nil?
      @title_align = 0
    end
    # ڂ̍WvZ
    rect = Rect.new()
    rect.width = window_width - standard_padding * 2
    rect.height = line_height
    page_max, m = self.item_max.divmod(page_item_max)
    page_max += 1 if m != 0
    for page in 0 .. page_max
      rect.x = page * (rect.width + spacing)
      draw_title_item(normal_color,rect,@title,@title_align)
    end
  end

  # ^Cg̕`iftHgj
  def draw_title_item(color,rect,title,title_align)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect.x + 4, rect.y, rect.width - 8, rect.height, title, title_align)
  end
end
