/**
 * JQuery スマートグリッドプラグイン
 */
(function($){
	
	/**
	 * テーブルのスマートデザイン化・コンテキストによるヘッダ長の自動設定
	 */
	$.fn.smarttable = function(headers){
		if(headers == null || headers == undefined) {
			return $(this);
		}
		
		var $$ = $(this);
		
		// テーブルヘッダ・ボディの基本設定
		var thead = $($$.children('thead').get(0));
		
		// TBODYをブロック要素に
		var tbody = $($$.children('tbody').get(0));
		tbody.css('display', 'block');
		tbody.css('overflow-x', 'hidden');
		tbody.css('overflow-y', 'auto');

		var tbody_tr = tbody.find('tr');
		tbody_tr.css('padding-bottom', 0);
		tbody_tr.css('margin', 0);
		
		// マウスオーバー・マウスアウト時の背景色
		var defaultColor = '#ccffcc';	// デフォルトのレコード背景色
		var selectedColor = '#ff9966';	// マウスオーバー時のレコード背景色
		
		tbody_tr.find('td').css('background-color', defaultColor);
		
		tbody_tr.mouseover(function(){
			$(this).find('td').css('background-color', selectedColor);
			$(this).find('td').css('cursor', 'pointer');
		}).mouseout(function(){
			$(this).find('td').css('background-color', defaultColor);
			$(this).find('td').css('cursor', 'auto');
		});
		
		
		// テーブルヘッダセルの基本設定
		var thead_tr = thead.find('tr');
		thead_tr.css('padding-bottom', 0);
		thead_tr.css('margin', 0);
		
		thead_tr.find('th').css('padding', 0);
		
		
		
		// ============================= テーブルヘッダに対してスタイルを設定：ここから ===============
		thead_tr.find('th').each(function(index, element){
			var text = $(element).text();
			var contentTitle = $('<div></div>');
			//contentTitle.addClass('content_title');
			contentTitle.css('padding', 0);
			contentTitle.css('margin', 0);
			contentTitle.css('min-width', '100%');
			contentTitle.css('max-width', '100%');
			contentTitle.css('width', '100%');
			contentTitle.css('height', '20px');
			contentTitle.css('font-weight', 'bold');
			
			
			// グラデーションの設定(主要ブラウザ対応)
			contentTitle.css('filter', "progid:DXImageTransform.Microsoft.gradient(GradientType=0, StartColorStr='#ccc', EndColorStr='#fff')");
			contentTitle.css('background', "-webkit-gradient(linear, left top, left bottom, from(#ccc), to(#fff))");
			contentTitle.css('background', "-moz-linear-gradient(top, #ccc, #fff)");
			contentTitle.css('background', "linear-gradient(top, #ccc, #fff)");
			
			
			contentTitle.css('line-height', '20px');
			contentTitle.text(text);
			$(element).text('');
			$(element).append(contentTitle);
		});
		// ============================= テーブルヘッダに対してスタイルを設定：まで ===============
		
		
		
		// ============================= テーブルデータの背景色変更：ここから ===============
		thead_tr.mouseover(function(e){
			$(this).find('th').css('cursor', 'pointer');
			//console.log(e);
			
			var getTr = function(currentElement){
				//console.log(currentElement.get(0));
				var tagName = currentElement[0].tagName;//
				if(tagName == 'TH') {
					return currentElement;
				} else {
					if(currentElement.parent()) {
						getTr(currentElement.parent());
					} else {
						return null;
					}
					
				}
			};
			
			var thObj = getTr($(e.target));
			
			var currentIndex = $(this).find('th').index($(e.target).parent());
			if(currentIndex < 0) {
				return false;
			}
			tbody_tr.each(function(index, element){
				
				$(element).find('td').eq(currentIndex).css('background-color', selectedColor);
			});
			
		}).mouseout(function(e){
			$(this).find('th').css('cursor', 'auto');
			
			var getTr = function(currentElement){
				var tagName = currentElement[0].tagName;//
				//console.log(tagName);
				if(tagName == 'TH') {
					return currentElement;
				} else {
					if(currentElement.parent()) {
						getTr(currentElement.parent());
					} else {
						return null;
					}
					
				}
			};
			
			var thObj = getTr($(e.target));
			
			var currentIndex = $(this).find('th').index($(e.target).parent());
			
			tbody_tr.each(function(index, element){
				$(element).find('td').eq(currentIndex).css('background-color', defaultColor);
			});
			
		});
		// ============================= テーブルデータの背景色変更：ここまで ===============
		
		
		
		// ============================= テーブルカラム長をコンテキストより設定：ここから ===============
		var w0 = 0;
		for(var val in headers.param) {
			var obj = headers.param[val];
			var content = $$.find('td.' + obj.id);
			
			var size = content.size();
			
			content.each(function(index, element){
				$(element).css('width', obj.width);
				
				if(index < size - 1) {
					$(element).css('border-bottom', 0);
				}
			});
			
			content = $$.find('th.' + obj.id);
			content.each(function(index, element){
				
				
				$(element).css('width', obj.width + 10);
				$(element).css('border-bottom', 0);
				
				w0 = w0 + obj.width + 10;
			});
		}
		// ============================= テーブルカラム長をコンテキストより設定：ここまで ===============
		
		$$.css('border-collapse', 'collapse');
		$$.css('border-spacing', '0px');
		$$.css('width', w0 + 30);
		$$.css('padding-top', 5);
		$$.css('padding-left', 5);
		$$.css('display', 'block');
		
		return $(this);
	};
//	
//	
//	
//	$.fn.tableresize = function(headers){
//		var $$ = $(this);
//		if(headers == null || headers == undefined) {
//			return $$;
//		}
//		
//		var w0 = 0;
//		for(var val in headers.param) {
//			var obj = headers.param[val];
//			var content = $$.find('td.' + obj.id);
//			
//			var size = content.size();
//			
//			content.each(function(index, element){
//				$(element).css('width', obj.width);
//				
//				if(index < size - 1) {
//					$(element).css('border-bottom', 0);
//				}
//			});
//			
//			content = $$.find('th.' + obj.id);
//			content.each(function(index, element){
//				$(element).css('width', obj.width + 10);
//				$(element).css('border-bottom', 0);
//				
//				w0 = w0 + obj.width + 10;
//			});
//		}
//		
//		return $$;
//	};
	
})(jQuery);
